/*
 * Decompiled with CFR 0.152.
 */
package net.parim.common.persistence.mybatis.paginate;

import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import net.parim.common.config.Global;
import net.parim.common.persistence.Page;
import net.parim.common.persistence.dialect.Dialect;
import net.parim.common.persistence.dialect.db.DB2Dialect;
import net.parim.common.persistence.dialect.db.DerbyDialect;
import net.parim.common.persistence.dialect.db.H2Dialect;
import net.parim.common.persistence.dialect.db.HSQLDialect;
import net.parim.common.persistence.dialect.db.MySQLDialect;
import net.parim.common.persistence.dialect.db.OracleDialect;
import net.parim.common.persistence.dialect.db.PostgreSQLDialect;
import net.parim.common.persistence.dialect.db.SQLServer2005Dialect;
import net.parim.common.persistence.dialect.db.SybaseDialect;
import net.parim.common.persistence.interceptor.PaginationInterceptor;
import net.parim.common.persistence.interceptor.SQLHelper;
import net.parim.common.persistence.mybatis.paginate.domain.PageImpl;
import net.parim.common.utils.Reflections;
import net.parim.common.utils.StringUtils;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.springframework.data.domain.Pageable;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class OffsetLimitInterceptor
implements Interceptor {
    private Log logger = LogFactory.getLog(this.getClass());
    private Dialect DIALECT;
    static int MAPPED_STATEMENT_INDEX = 0;
    static int PARAMETER_INDEX = 1;
    static int ROWBOUNDS_INDEX = 2;
    static int RESULT_HANDLER_INDEX = 3;
    static ExecutorService pool;
    String dialectClass;
    boolean asyncTotalCount = false;

    public Object intercept(Invocation invocation) throws Throwable {
        Object parameter;
        Object[] queryArgs = invocation.getArgs();
        MappedStatement mappedStatement = (MappedStatement)queryArgs[MAPPED_STATEMENT_INDEX];
        Object prefParameter = queryArgs[PARAMETER_INDEX];
        if (!(prefParameter instanceof HashMap)) {
            return invocation.proceed();
        }
        int size = ((HashMap)prefParameter).size() / 2;
        Object lastParam = ((HashMap)prefParameter).get("" + (size - 1));
        if (null != lastParam && lastParam instanceof Pageable) {
            if (size == 1) {
                queryArgs[OffsetLimitInterceptor.PARAMETER_INDEX] = null;
                parameter = null;
            } else if (size == 2) {
                queryArgs[OffsetLimitInterceptor.PARAMETER_INDEX] = ((HashMap)prefParameter).get("0");
                parameter = ((HashMap)prefParameter).get("0");
            } else {
                parameter = prefParameter;
            }
        } else {
            return invocation.proceed();
        }
        Pageable pageable = (Pageable)lastParam;
        Page<Object> page = new Page<Object>();
        page.setPageNo(pageable.getPageNumber() + 1);
        page.setPageSize(pageable.getPageSize());
        if (page != null && page.getPageSize() != -1) {
            BoundSql boundSql = mappedStatement.getBoundSql(parameter);
            if (StringUtils.isBlank(boundSql.getSql())) {
                return null;
            }
            String originalSql = boundSql.getSql().trim();
            page.setCount(SQLHelper.getCount(originalSql, null, mappedStatement, parameter, boundSql, this.logger));
            String pageSql = SQLHelper.generatePageSql(originalSql, page, this.DIALECT);
            invocation.getArgs()[2] = new RowBounds(0, Integer.MAX_VALUE);
            BoundSql newBoundSql = new BoundSql(mappedStatement.getConfiguration(), pageSql, boundSql.getParameterMappings(), boundSql.getParameterObject());
            if (Reflections.getFieldValue(boundSql, "metaParameters") != null) {
                MetaObject mo = (MetaObject)Reflections.getFieldValue(boundSql, "metaParameters");
                Reflections.setFieldValue(newBoundSql, "metaParameters", mo);
            }
            MappedStatement newMs = this.copyFromMappedStatement(mappedStatement, new PaginationInterceptor.BoundSqlSqlSource(newBoundSql));
            invocation.getArgs()[0] = newMs;
            PageImpl pageImpl = new PageImpl((List)invocation.proceed(), pageable, page.getCount());
            return pageImpl;
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        this.initProperties(properties);
    }

    protected void initProperties(Properties p) {
        Dialect dialect = null;
        String dbType = Global.getConfig("jdbc.type");
        if ("db2".equals(dbType)) {
            dialect = new DB2Dialect();
        } else if ("derby".equals(dbType)) {
            dialect = new DerbyDialect();
        } else if ("h2".equals(dbType)) {
            dialect = new H2Dialect();
        } else if ("hsql".equals(dbType)) {
            dialect = new HSQLDialect();
        } else if ("mysql".equals(dbType)) {
            dialect = new MySQLDialect();
        } else if ("oracle".equals(dbType)) {
            dialect = new OracleDialect();
        } else if ("postgre".equals(dbType)) {
            dialect = new PostgreSQLDialect();
        } else if ("mssql".equals(dbType) || "sqlserver".equals(dbType)) {
            dialect = new SQLServer2005Dialect();
        } else if ("sybase".equals(dbType)) {
            dialect = new SybaseDialect();
        }
        if (dialect == null) {
            throw new RuntimeException("mybatis dialect error.");
        }
        this.DIALECT = dialect;
    }

    private MappedStatement copyFromMappedStatement(MappedStatement ms, SqlSource newSqlSource) {
        MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), ms.getId(), newSqlSource, ms.getSqlCommandType());
        builder.resource(ms.getResource());
        builder.fetchSize(ms.getFetchSize());
        builder.statementType(ms.getStatementType());
        builder.keyGenerator(ms.getKeyGenerator());
        if (ms.getKeyProperties() != null) {
            for (String keyProperty : ms.getKeyProperties()) {
                builder.keyProperty(keyProperty);
            }
        }
        builder.timeout(ms.getTimeout());
        builder.parameterMap(ms.getParameterMap());
        builder.resultMaps(ms.getResultMaps());
        builder.cache(ms.getCache());
        return builder.build();
    }
}

