/*
 * Decompiled with CFR 0.152.
 */
package net.parim.common.persistence.mybatis.paginate.domain;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.Sort;
import org.springframework.util.Assert;

abstract class Chunk<T>
extends ArrayList<T>
implements Slice<T>,
Serializable {
    private static final long serialVersionUID = 867755909294344406L;
    private final List<T> content = new ArrayList<T>();
    private final Pageable pageable;

    public Chunk(List<T> content, Pageable pageable) {
        super(content);
        Assert.notNull(content, (String)"Content must not be null!");
        this.content.addAll(content);
        this.pageable = pageable;
    }

    public int getNumber() {
        return this.pageable == null ? 0 : this.pageable.getPageNumber();
    }

    public int getSize() {
        return this.pageable == null ? 0 : this.pageable.getPageSize();
    }

    public int getNumberOfElements() {
        return this.content.size();
    }

    public boolean hasPrevious() {
        return this.getNumber() > 0;
    }

    public boolean isFirst() {
        return !this.hasPrevious();
    }

    public boolean isLast() {
        return !this.hasNext();
    }

    public Pageable nextPageable() {
        return this.hasNext() ? this.pageable.next() : null;
    }

    public Pageable previousPageable() {
        if (this.hasPrevious()) {
            return this.pageable.previousOrFirst();
        }
        return null;
    }

    public boolean hasContent() {
        return !this.content.isEmpty();
    }

    public List<T> getContent() {
        return Collections.unmodifiableList(this.content);
    }

    public Sort getSort() {
        return this.pageable == null ? null : this.pageable.getSort();
    }

    @Override
    public Iterator<T> iterator() {
        return this.content.iterator();
    }

    protected <S> List<S> getConvertedContent(Converter<? super T, ? extends S> converter) {
        Assert.notNull(converter, (String)"Converter must not be null!");
        ArrayList<Object> result = new ArrayList<Object>(this.content.size());
        for (T element : this) {
            result.add(converter.convert(element));
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Chunk)) {
            return false;
        }
        Chunk that = (Chunk)obj;
        boolean contentEqual = this.content.equals(that.content);
        boolean pageableEqual = this.pageable == null ? that.pageable == null : this.pageable.equals(that.pageable);
        return contentEqual && pageableEqual;
    }

    @Override
    public int hashCode() {
        int result = 17;
        result += 31 * (this.pageable == null ? 0 : this.pageable.hashCode());
        return result += 31 * this.content.hashCode();
    }
}

