/*
 * Decompiled with CFR 0.152.
 */
package net.parim.common.utils;

import java.io.Serializable;
import java.security.SecureRandom;
import java.util.UUID;
import net.parim.common.utils.Encodes;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.eis.SessionIdGenerator;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy(value=false)
public class IdGen
implements SessionIdGenerator {
    private static SecureRandom random = new SecureRandom();

    public static String uuid() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static long randomLong() {
        return Math.abs(random.nextLong());
    }

    public static String randomBase62(int length) {
        byte[] randomBytes = new byte[length];
        random.nextBytes(randomBytes);
        return Encodes.encodeBase62(randomBytes);
    }

    public String getNextId() {
        return IdGen.uuid();
    }

    public Serializable generateId(Session session) {
        return IdGen.uuid();
    }

    public static void main(String[] args) {
        System.out.println(IdGen.uuid());
        System.out.println(IdGen.uuid().length());
        System.out.println(new IdGen().getNextId());
        for (int i = 0; i < 1000; ++i) {
            System.out.println(IdGen.randomLong() + "  " + IdGen.randomBase62(5));
        }
    }
}

