/*
 * Decompiled with CFR 0.152.
 */
package net.parim.common.web;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolationException;
import javax.validation.ValidationException;
import net.parim.common.mapper.JsonMapper;
import net.parim.common.message.Message;
import net.parim.common.utils.DateUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.ui.Model;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

public abstract class BaseController {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${adminPath}")
    protected String adminPath;
    @Value(value="${frontPath}")
    protected String frontPath;
    @Value(value="${urlSuffix}")
    protected String urlSuffix;
    @Autowired
    MessageSource messageSource;

    protected boolean beanValidator(Model model, Object object, Class<?> ... groups) {
        System.out.println("kaotamade");
        return true;
    }

    protected boolean beanValidator(RedirectAttributes redirectAttributes, Object object, Class<?> ... groups) {
        return true;
    }

    protected void beanValidator(Object object, Class<?> ... groups) {
    }

    protected String getMessage(String code, Object[] args) {
        String message;
        try {
            message = this.messageSource.getMessage(code, args, this.getLocale());
        }
        catch (NoSuchMessageException e) {
            this.logger.warn(e.getMessage());
            message = code;
        }
        return message;
    }

    protected Locale getLocale() {
        return LocaleContextHolder.getLocale();
    }

    protected void addMessage(Model model, String code, String ... args) {
        Message message = new Message(this.getMessage(code, args));
        model.addAttribute("message", (Object)message);
    }

    protected void addMessage(RedirectAttributes redirectAttributes, String code, String ... args) {
        Message message = new Message(this.getMessage(code, args));
        redirectAttributes.addFlashAttribute("message", (Object)message);
    }

    protected void addSuccess(Model model, String code, String ... args) {
        Message message = new Message("<br/>", Message.Type.success, this.getMessage(code, args));
        model.addAttribute("message", (Object)message);
    }

    protected void addSuccess(RedirectAttributes redirectAttributes, String code, String ... args) {
        Message message = new Message("<br/>", Message.Type.success, this.getMessage(code, args));
        redirectAttributes.addFlashAttribute("message", (Object)message);
    }

    protected void addError(Model model, String code, String ... args) {
        Message message = new Message("<br/>", Message.Type.error, this.getMessage(code, args));
        model.addAttribute("message", (Object)message);
    }

    protected void addError(RedirectAttributes redirectAttributes, String code, String ... args) {
        Message message = new Message("<br/>", Message.Type.error, this.getMessage(code, args));
        redirectAttributes.addFlashAttribute("message", (Object)message);
    }

    protected void addError(Model model, Message message) {
        message.setType(Message.Type.error);
        message.setSeparator("<br/>");
        model.addAttribute("message", (Object)message);
    }

    protected void addError(RedirectAttributes redirectAttributes, Message message) {
        message.setType(Message.Type.error);
        message.setSeparator("<br/>");
        redirectAttributes.addAttribute("message", (Object)message);
    }

    protected void addBindingError(Model model, BindingResult result) {
        List<String> errors = this.getErrorMessages(result);
        this.addError(model, new Message(errors.toArray(new String[errors.size()])));
        model.addAllAttributes(this.getFieldErrorMessages(result));
    }

    protected void addBindingError(RedirectAttributes redirectAttributes, BindingResult result) {
        List<String> errors = this.getErrorMessages(result);
        this.addError(redirectAttributes, new Message(errors.toArray(new String[errors.size()])));
        redirectAttributes.addAllAttributes(this.getFieldErrorMessages(result));
    }

    protected List<String> getErrorMessages(BindingResult result) {
        ArrayList<String> errors = new ArrayList<String>();
        for (FieldError error : result.getFieldErrors()) {
            errors.add(error.getField() + ":" + error.getDefaultMessage());
        }
        return errors;
    }

    protected Map<String, Message> getFieldErrorMessages(BindingResult result) {
        HashMap<String, Message> fieldErrors = new HashMap<String, Message>();
        for (FieldError error : result.getFieldErrors()) {
            fieldErrors.put("ERR_" + error.getField(), new Message(error.getDefaultMessage()));
        }
        return fieldErrors;
    }

    protected String renderString(HttpServletResponse response, Object object) {
        return this.renderString(response, JsonMapper.toJsonString(object), "application/json");
    }

    protected String renderString(HttpServletResponse response, String string, String type) {
        try {
            response.reset();
            response.setContentType(type);
            response.setCharacterEncoding("utf-8");
            response.getWriter().print(string);
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @ExceptionHandler(value={BindException.class, ConstraintViolationException.class, ValidationException.class})
    public String bindException() {
        return "error/400";
    }

    @ExceptionHandler(value={AuthenticationException.class})
    public String authenticationException() {
        return "error/403";
    }

    @InitBinder
    protected void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(String.class, (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                this.setValue(text == null ? null : StringEscapeUtils.escapeHtml4((String)text.trim()));
            }

            @Override
            public String getAsText() {
                Object value = this.getValue();
                return value != null ? value.toString() : "";
            }
        });
        binder.registerCustomEditor(Date.class, (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                this.setValue(DateUtils.parseDate(text));
            }
        });
    }
}

