/*
 * Decompiled with CFR 0.152.
 */
package net.parim.system.persistent;

import com.fasterxml.jackson.annotation.JsonBackReference;
import java.util.List;
import javax.validation.constraints.NotNull;
import net.parim.common.utils.Reflections;
import net.parim.system.persistent.DataEntity;

public abstract class TreeEntity<E extends TreeEntity<?>>
extends DataEntity<E> {
    private static final long serialVersionUID = 1L;
    protected E parent;
    protected List<E> children;
    protected String name;
    protected Integer sort;
    protected Long childCount;

    public TreeEntity() {
    }

    public TreeEntity(Long id) {
        super(id);
    }

    @JsonBackReference
    @NotNull
    public abstract E getParent();

    public abstract void setParent(E var1);

    public abstract List<E> getChildren();

    public abstract void setChildren(List<E> var1);

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getSort() {
        return this.sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public Long getParentId() {
        Long id = null;
        if (this.parent != null) {
            id = (Long)Reflections.getFieldValue(this.parent, (String)"id");
        }
        return id == null ? 0L : id;
    }

    public Long getChildCount() {
        return this.childCount;
    }

    public void setChildCount(Long childCount) {
        this.childCount = childCount;
    }

    public Boolean getIsParent() {
        return this.getChildCount() != null && this.getChildCount() > 0L;
    }
}

