/*
 * Decompiled with CFR 0.152.
 */
package net.parim.system.security;

import java.util.List;
import javax.annotation.PostConstruct;
import net.parim.system.entity.Privilege;
import net.parim.system.entity.User;
import net.parim.system.entity.UserRole;
import net.parim.system.security.CustomCredentialsMatcher;
import net.parim.system.security.UsernamePasswordToken;
import net.parim.system.service.AccountService;
import net.parim.system.service.PermissionService;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.util.ByteSource;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SystemAuthorizingRealm
extends AuthorizingRealm {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Autowired
    private AccountService accountService;
    @Autowired
    private PermissionService permissionService;

    @Autowired
    public SystemAuthorizingRealm(DefaultWebSecurityManager realmSecurityManager) {
        if (null != realmSecurityManager) {
            realmSecurityManager.setRealm((Realm)this);
        }
    }

    @PostConstruct
    public void initCredentialsMatcher() {
        this.setCredentialsMatcher((CredentialsMatcher)new CustomCredentialsMatcher());
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken paramAuthenticationToken) throws AuthenticationException {
        User user;
        if (!(paramAuthenticationToken instanceof UsernamePasswordToken)) {
            return null;
        }
        UsernamePasswordToken authcToken = (UsernamePasswordToken)paramAuthenticationToken;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Login submit, active session size: {}, username: {}", (Object)0, (Object)authcToken.getUsername());
        }
        if ((user = this.accountService.findUserByUsername(authcToken.getUsername())) != null) {
            byte[] salt = user.getSalt().getBytes();
            return new SimpleAuthenticationInfo((Object)user, (Object)user.getPassword(), ByteSource.Util.bytes((byte[])salt), ((Object)((Object)this)).getClass().getName());
        }
        return null;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection paramPrincipalCollection) {
        User user = (User)((Object)this.getAvailablePrincipal(paramPrincipalCollection));
        if (user != null) {
            return this.authzPermissions(user);
        }
        return null;
    }

    protected AuthorizationInfo authzPermissions(User user) {
        SimpleAuthorizationInfo authInfo = new SimpleAuthorizationInfo();
        List<UserRole> userPrivs = this.permissionService.findUserPrivilegeXref(user);
        if (null != userPrivs && !userPrivs.isEmpty()) {
            for (UserRole userRole : userPrivs) {
                String permission = userRole.getPrivilege().getIdentifier();
                if (userRole.getPrivilege().getType() == Privilege.Type.resource) {
                    permission = permission + ":" + userRole.getTargetId();
                }
                authInfo.addStringPermission(permission);
                this.logger.debug("User " + user.getId() + user.getUsername() + " is permissed: " + permission);
            }
        }
        if (null != authInfo.getStringPermissions()) {
            this.logger.debug(authInfo.getStringPermissions().size() + "");
        }
        return authInfo;
    }
}

