/*
 * Decompiled with CFR 0.152.
 */
package net.parim.system.service;

import net.parim.system.entity.User;
import net.parim.system.exception.IncorrectCredentialsException;
import net.parim.system.exception.UnknownAccountException;
import net.parim.system.repository.UserRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AccountService {
    @Autowired
    private UserRepository userRepository;

    public User findUserById(Long id) {
        return (User)this.userRepository.findOne(id);
    }

    public User findUserByUsername(String username) {
        return this.userRepository.findUserByUsername(username);
    }

    public User checkUser(String username, String password) throws UnknownAccountException, IncorrectCredentialsException {
        User user = this.checkUserExist(username);
        this.checkPassword(user.getPassword(), password);
        return user;
    }

    public User checkUserExist(String username) throws UnknownAccountException {
        User user = this.userRepository.findUserByUsername(username);
        if (null == user) {
            throw new UnknownAccountException();
        }
        return user;
    }

    private void checkPassword(String userPassword, String password) throws IncorrectCredentialsException {
        if (null == userPassword || !userPassword.equals(password)) {
            throw new IncorrectCredentialsException();
        }
    }
}

