/*
 * Decompiled with CFR 0.152.
 */
package net.parim.system.service;

import java.io.Serializable;
import net.parim.common.persistence.CrudRepository;
import net.parim.common.service.CrudService;
import net.parim.system.entity.User;
import net.parim.system.persistent.DataEntity;
import net.parim.system.utils.UserUtils;

public abstract class DataCrudService<R extends CrudRepository<T, ID>, T extends DataEntity<?>, ID extends Serializable>
extends CrudService<R, T, ID> {
    protected User currentUser;

    public void save(T entity) {
        if (entity.isNewRecord()) {
            this.add(entity);
        } else {
            this.update(entity);
        }
    }

    public void add(T entity) {
        ((DataEntity)((Object)entity)).setCreatedBy(this.getCurrentUser());
        this.repository.insert(entity);
    }

    public void update(T entity) {
        ((DataEntity)((Object)entity)).setLastUpdatedBy(this.getCurrentUser());
        this.repository.update(entity);
    }

    protected User getCurrentUser() {
        if (this.currentUser == null) {
            this.currentUser = UserUtils.getCurrentUser();
        }
        return this.currentUser;
    }
}

