/*
 * Decompiled with CFR 0.152.
 */
package net.parim.system.service;

import java.util.List;
import net.parim.common.service.CrudService;
import net.parim.system.entity.Privilege;
import net.parim.system.entity.User;
import net.parim.system.repository.PrivilegeRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class PrivilegeService
extends CrudService<PrivilegeRepository, Privilege, Long> {
    @Autowired
    PrivilegeRepository privilegeRepository;
    User user = new User();

    public PrivilegeService() {
        this.user.setId(1L);
    }

    public void createPrivilege(Privilege privilege) {
        privilege.setCreatedBy(this.user);
        privilege.setLastUpdatedBy(this.user);
        this.privilegeRepository.insert(privilege);
    }

    public void updatePrivilege(Privilege privilege) {
        privilege.setLastUpdatedBy(this.user);
        this.privilegeRepository.update(privilege);
    }

    public void savePrivilege(Privilege privilege) {
        if (!privilege.isNewRecord()) {
            this.updatePrivilege(privilege);
        } else {
            this.createPrivilege(privilege);
        }
    }

    public void removePrivilege(Privilege privilege) {
        this.privilegeRepository.delete(privilege);
    }

    public void removePrivileg(Long id) {
        this.privilegeRepository.delete(id);
    }

    public void removePrivilege(List<Privilege> privileges) {
        for (Privilege privilege : privileges) {
            this.removePrivilege(privilege);
        }
    }

    public Privilege findPrivilegeById(Long id) {
        return (Privilege)this.privilegeRepository.findOne(id);
    }

    public Privilege findPrivilegeByIdentifier(String identifier) {
        return this.privilegeRepository.findPrivilegeByIdentifier(identifier);
    }

    public List<Privilege> findAllPrivileges() {
        return this.privilegeRepository.findAll();
    }

    public List<Privilege> findAllPrivileges(Privilege privilege) {
        return this.privilegeRepository.findAll(privilege);
    }

    public Page<Privilege> findAllPrivileges(Pageable pageable) {
        return this.findAllPrivileges(null, pageable);
    }

    public Page<Privilege> findAllPrivileges(Privilege privilege, Pageable pageable) {
        return (Page)this.privilegeRepository.findAll(privilege, pageable);
    }
}

