/*
 * Decompiled with CFR 0.152.
 */
package net.parim.system.service;

import java.util.List;
import net.parim.system.entity.Role;
import net.parim.system.entity.User;
import net.parim.system.repository.RoleRepository;
import net.parim.system.service.DataCrudService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class RoleService
extends DataCrudService<RoleRepository, Role, Long> {
    @Autowired
    RoleRepository roleRepository;
    User user = new User();

    public RoleService() {
        this.user.setId(1L);
    }

    public void createRole(Role role) {
        role.setCreatedBy(this.user);
        role.setLastUpdatedBy(this.user);
        this.roleRepository.insert(role);
    }

    public void updateRole(Role role) {
        role.setLastUpdatedBy(this.user);
        this.roleRepository.update(role);
    }

    public void saveRole(Role role) {
        if (!role.isNewRecord()) {
            this.updateRole(role);
        } else {
            this.createRole(role);
        }
    }

    public void removeRole(Role role) {
        this.roleRepository.delete(role);
    }

    public void removeRole(Long id) {
        this.roleRepository.delete(id);
    }

    public void removeRole(List<Role> roles) {
        for (Role role : roles) {
            this.removeRole(role);
        }
    }

    public Role findRoleById(Long id) {
        return (Role)this.roleRepository.findOne(id);
    }

    public List<Role> findAllRoles() {
        return this.roleRepository.findAll();
    }

    public List<Role> findAllRoles(Role role) {
        return this.roleRepository.findAll(role);
    }

    public Page<Role> findAllRoles(Pageable pageable) {
        return this.findAllRoles(null, pageable);
    }

    public Page<Role> findAllRoles(Role role, Pageable pageable) {
        return (Page)this.roleRepository.findAll(role, pageable);
    }
}

