/*
 * Decompiled with CFR 0.152.
 */
package net.parim.system.service;

import java.util.List;
import net.parim.system.entity.Site;
import net.parim.system.entity.User;
import net.parim.system.entity.UserGroup;
import net.parim.system.repository.SiteRepository;
import net.parim.system.service.DataCrudService;
import net.parim.system.service.UserGroupService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SiteService
extends DataCrudService<SiteRepository, Site, Long> {
    @Autowired
    private SiteRepository siteRepository;
    @Autowired
    private UserGroupService userGroupService;
    User user = new User();

    public SiteService() {
        this.user.setId(1L);
    }

    @Override
    public void save(Site site) {
        if (site.getParent() == null || site.getParent().isNewRecord()) {
            Site rootSite = new Site(1L);
            site.setParent(rootSite);
        }
        if (!site.isNewRecord()) {
            site.setLastUpdatedBy(this.user);
            this.siteRepository.update(site);
        } else {
            site.setCreatedBy(this.user);
            site.setLastUpdatedBy(this.user);
            this.siteRepository.insert(site);
        }
    }

    public void remove(Site site) {
        this.removeUserGroups(site);
        this.removeChildren(site);
        this.siteRepository.delete(site);
    }

    public void remove(List<Site> sites) {
        for (Site site : sites) {
            this.remove(site);
        }
    }

    public Site findOne(Long id) {
        return (Site)this.siteRepository.findOne(id);
    }

    public List<Site> findAll() {
        return this.siteRepository.findAll();
    }

    public List<Site> findRoots() {
        return this.siteRepository.findAllRoots(null, null);
    }

    public List<Site> findChildren(Site site) {
        return this.siteRepository.findAllChildren(site);
    }

    public void removeUserGroups(Site site) {
        List<UserGroup> userGroups = this.userGroupService.findBySite(site);
        this.userGroupService.remove(userGroups);
    }

    public void removeChildren(Site site) {
        List<Site> children = this.findChildren(site);
        this.remove(children);
    }
}

