/*
 * Decompiled with CFR 0.152.
 */
package net.parim.system.service;

import java.util.ArrayList;
import java.util.List;
import net.parim.common.web.MenuProvider;
import net.parim.system.entity.Menu;
import net.parim.system.repository.MenuRepository;
import net.parim.system.service.DataCrudService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class SystemService
extends DataCrudService<MenuRepository, Menu, Long>
implements MenuProvider {
    @Autowired
    private MenuRepository menuRepository;

    public Menu findMenuById(Long id) {
        return (Menu)this.menuRepository.findOne(id);
    }

    public List<Menu> findAllMenu() {
        return this.menuRepository.findAll();
    }

    public void saveMenu(Menu menu) {
        menu.setParent(this.findMenuById(menu.getParent().getId()));
        if (menu.isNewRecord()) {
            this.menuRepository.insert(menu);
        } else {
            this.menuRepository.update(menu);
        }
    }

    public void removeMenu(Menu menu) {
        List<?> children = this.menuRepository.findAllChildren(menu);
        for (Menu m : children) {
            this.menuRepository.delete(m);
        }
        this.menuRepository.delete(menu);
    }

    public List<?> getMenuList() {
        Menu menu = new Menu();
        menu.setId(1L);
        menu.setName("\u7ba1\u7406\u63a7\u5236\u53f0");
        Menu dashBoard = new Menu();
        dashBoard.setId(2L);
        dashBoard.setName("\u6211\u7684\u4eea\u8868\u76d8");
        ArrayList<Menu> menus = new ArrayList<Menu>();
        menus.add(menu);
        menus.add(dashBoard);
        return menus;
    }

    public List<Menu> findAllParents(Menu menu) {
        return this.menuRepository.findAllParents(menu);
    }

    @Cacheable(value={"default"}, keyGenerator="wiselyKeyGenerator")
    public List<?> getTopLevelMenus() {
        return this.menuRepository.findAllRoots(null, null);
    }

    @Cacheable(value={"default"}, keyGenerator="wiselyKeyGenerator")
    public List<?> getMenuListByParentId(String parentId) {
        Menu menu = this.menuRepository.findByIdentifier(parentId);
        return this.menuRepository.findChildren(menu);
    }

    @Cacheable(value={"default"}, keyGenerator="wiselyKeyGenerator")
    public List<?> getUserCustomMenus() {
        Menu dashBoard = new Menu();
        dashBoard.setId(100L);
        dashBoard.setName("\u6211\u7684\u4eea\u8868\u76d8");
        ArrayList<Menu> menus = new ArrayList<Menu>();
        menus.add(dashBoard);
        return menus;
    }
}

