/*
 * Decompiled with CFR 0.152.
 */
package net.parim.system.service;

import java.util.List;
import net.parim.common.security.PasswordHelper;
import net.parim.common.utils.StringUtils;
import net.parim.system.entity.User;
import net.parim.system.repository.UserRepository;
import net.parim.system.service.DataCrudService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class UserService
extends DataCrudService<UserRepository, User, Long> {
    @Autowired
    UserRepository userRepository;

    @Override
    public void save(User user) {
        User cuUser = new User();
        cuUser.setId(1L);
        if (user.isNewRecord()) {
            String salt = PasswordHelper.generateSalt();
            String plainPassword = user.getPassword();
            if (StringUtils.isBlank((String)plainPassword)) {
                plainPassword = "888888";
            }
            user.setSalt(salt);
            user.setPassword(PasswordHelper.entryptPassword((String)plainPassword, (String)salt));
            user.setCreatedBy(cuUser);
            user.setLastUpdatedBy(cuUser);
            this.userRepository.insert(user);
        } else {
            String salt = PasswordHelper.generateSalt();
            String plainPassword = user.getPassword();
            if (!StringUtils.isBlank((String)plainPassword)) {
                user.setSalt(salt);
                user.setPassword(PasswordHelper.entryptPassword((String)plainPassword, (String)salt));
            }
            user.setLastUpdatedBy(cuUser);
            this.userRepository.update(user);
        }
    }

    public User findOne(Long id) {
        return (User)this.userRepository.findOne(id);
    }

    public List<User> findAll(User user) {
        return this.userRepository.findAll(user);
    }

    public Page<User> findAll(User user, Pageable pageable) {
        return (Page)this.userRepository.findAll(user, pageable);
    }
}

