/*
 * Decompiled with CFR 0.152.
 */
package net.parim.system.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.parim.common.utils.CacheUtils;
import net.parim.common.utils.SpringContextHolder;
import net.parim.system.entity.Dict;
import net.parim.system.repository.DictRepository;
import org.apache.commons.lang3.StringUtils;

public class DictUtils {
    private static DictRepository dictRepository = (DictRepository)SpringContextHolder.getBean(DictRepository.class);
    public static final String CACHE_DICT_MAP = "dictMap";

    public static String getDictLabel(String value, String type, String defaultValue) {
        if (StringUtils.isNotBlank((CharSequence)type) && StringUtils.isNotBlank((CharSequence)value)) {
            for (Dict dict : DictUtils.getDictList(type)) {
                if (!type.equals(dict.getType()) || !value.equals(dict.getValue())) continue;
                return dict.getLabel();
            }
        }
        return defaultValue;
    }

    public static String getDictLabels(String values, String type, String defaultValue) {
        if (StringUtils.isNotBlank((CharSequence)type) && StringUtils.isNotBlank((CharSequence)values)) {
            ArrayList valueList = Lists.newArrayList();
            for (String value : StringUtils.split((String)values, (String)",")) {
                valueList.add(DictUtils.getDictLabel(value, type, defaultValue));
            }
            return StringUtils.join((Iterable)valueList, (String)",");
        }
        return defaultValue;
    }

    public static String getDictValue(String label, String type, String defaultLabel) {
        if (StringUtils.isNotBlank((CharSequence)type) && StringUtils.isNotBlank((CharSequence)label)) {
            for (Dict dict : DictUtils.getDictList(type)) {
                if (!type.equals(dict.getType()) || !label.equals(dict.getLabel())) continue;
                return dict.getValue();
            }
        }
        return defaultLabel;
    }

    public static List<Dict> getDictList(String type) {
        List dictList;
        Map dictMap = (Map)CacheUtils.get((String)CACHE_DICT_MAP);
        if (dictMap == null) {
            dictMap = Maps.newHashMap();
            for (Dict dict : dictRepository.findAll()) {
                List dictList2 = (List)dictMap.get(dict.getType());
                if (dictList2 != null) {
                    dictList2.add(dict);
                    continue;
                }
                dictMap.put(dict.getType(), Lists.newArrayList((Object[])new Dict[]{dict}));
            }
            CacheUtils.put((String)CACHE_DICT_MAP, (Object)dictMap);
        }
        if ((dictList = (List)dictMap.get(type)) == null) {
            dictList = Lists.newArrayList();
        }
        return dictList;
    }

    public static String getDictListJson(String type) {
        return "";
    }
}

