/*
 * Decompiled with CFR 0.152.
 */
package net.parim.system.utils;

import java.util.List;
import net.parim.common.utils.SpringContextHolder;
import net.parim.system.entity.Menu;
import net.parim.system.entity.User;
import net.parim.system.repository.MenuRepository;
import net.parim.system.repository.UserRepository;
import net.parim.system.security.UserToken;
import org.apache.shiro.SecurityUtils;
import org.springframework.cache.annotation.Cacheable;

public class UserUtils {
    private static UserRepository userRepository = (UserRepository)SpringContextHolder.getBean(UserRepository.class);
    private static MenuRepository menuRepository = (MenuRepository)SpringContextHolder.getBean(MenuRepository.class);

    public static List<Menu> getMenuList() {
        return menuRepository.findAll();
    }

    public static UserToken getUserToken() {
        UserToken userToken = new UserToken();
        userToken.setId(1L);
        return userToken;
    }

    @Cacheable(value={"default"}, keyGenerator="wiselyKeyGenerator")
    public static User getUser(Long key) {
        return (User)userRepository.findOne(key);
    }

    public static User getCurrentUser() {
        return (User)((Object)SecurityUtils.getSubject().getSession().getAttribute((Object)"userToken"));
    }
}

