/*
 * Decompiled with CFR 0.152.
 */
package net.qimooc.commons.entity;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.beanutils.BeanUtils;
import org.mapstruct.MappingTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface EntityMapper<M, E> {
    public static final Logger logger = LoggerFactory.getLogger(EntityMapper.class);

    public M toModel(E var1);

    public E toEntity(M var1);

    public void updateEntity(M var1, @MappingTarget E var2);

    default public void updateEntity(Map<String, ? extends Object> partial, @MappingTarget E entity) {
        if (Objects.isNull(partial) || Objects.isNull(entity)) {
            return;
        }
        try {
            BeanUtils.populate(entity, partial);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
    }
}

