/*
 * Decompiled with CFR 0.152.
 */
package net.qimooc.commons.entity.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import jakarta.persistence.AttributeConverter;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrayAttributeConverter<T>
implements AttributeConverter<Collection<T>, String> {
    private static final Logger logger = LoggerFactory.getLogger(ArrayAttributeConverter.class);

    public static <B> Class ofConverter() {
        return new ArrayAttributeConverter().getClass();
    }

    public String convertToDatabaseColumn(Collection<T> attribute) {
        try {
            return Objects.nonNull(attribute) ? new ObjectMapper().writeValueAsString(attribute) : null;
        }
        catch (JsonProcessingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Collection<T> convertToEntityAttribute(String dbData) {
        try {
            if (StringUtils.isBlank((CharSequence)dbData)) {
                return this.empty();
            }
            ObjectMapper mapper = new ObjectMapper();
            CollectionType collectionType = mapper.getTypeFactory().constructCollectionType(List.class, this.getObjectType());
            List list = (List)mapper.readValue(dbData, (JavaType)collectionType);
            return list;
        }
        catch (JsonProcessingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return this.empty();
        }
    }

    protected Collection<T> empty() {
        return new ArrayList();
    }

    protected Class<T> getObjectType() {
        Class clazz = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        return clazz;
    }
}

