/*
 * Decompiled with CFR 0.152.
 */
package net.qimooc.commons.entity.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.persistence.AttributeConverter;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapAttributeConverter
implements AttributeConverter<Map<String, Object>, String> {
    private static final Logger logger = LoggerFactory.getLogger(MapAttributeConverter.class);

    public String convertToDatabaseColumn(Map<String, Object> attribute) {
        try {
            return attribute != null ? new ObjectMapper().writeValueAsString(attribute) : null;
        }
        catch (JsonProcessingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Map<String, Object> convertToEntityAttribute(String dbData) {
        try {
            return StringUtils.isBlank((CharSequence)dbData) ? new HashMap<String, Object>() : (Map)new ObjectMapper().readValue(dbData, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (JsonProcessingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return new HashMap<String, Object>();
        }
    }
}

