/*
 * Decompiled with CFR 0.152.
 */
package net.qimooc.commons.entity.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.persistence.AttributeConverter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;

public class ObjectAttributeConverter<T>
implements AttributeConverter<T, String> {
    private static final Logger logger = LoggerFactory.getLogger(ObjectAttributeConverter.class);

    public static <B> Class ofConverter() {
        return new ObjectAttributeConverter().getClass();
    }

    public String convertToDatabaseColumn(T attribute) {
        try {
            return attribute != null ? new ObjectMapper().writeValueAsString(attribute) : null;
        }
        catch (JsonProcessingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public T convertToEntityAttribute(String dbData) {
        try {
            return (T)(StringUtils.isBlank((CharSequence)dbData) ? this.empty() : new ObjectMapper().readValue(dbData, this.getObjectType()));
        }
        catch (JsonProcessingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return this.empty();
        }
    }

    @Nullable
    protected T empty() {
        try {
            Class<T> clazz = this.getObjectType();
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    protected Class<T> getObjectType() {
        Class clazz = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        return clazz;
    }
}

