/*
 * Decompiled with CFR 0.152.
 */
package net.qimooc.commons.exceptions;

import net.qimooc.commons.i18n.LocaleMessageSourceService;
import net.qimooc.commons.spring.SpringUtil;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

@ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
public class BusinessException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    protected String messageKey;
    protected transient Object[] args;
    protected transient LocaleMessageSourceService messageSourceService = SpringUtil.getBean(LocaleMessageSourceService.class);

    public BusinessException() {
    }

    public BusinessException(String message, Throwable cause) {
        super(message, cause);
    }

    public BusinessException(String messageKey, Object[] args) {
        this.messageKey = messageKey;
        this.args = args;
    }

    public BusinessException(String message) {
        super(message);
    }

    public BusinessException(Throwable cause) {
        super(cause);
    }

    protected BusinessException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
    }

    @Override
    public String getLocalizedMessage() {
        return this.getMessage();
    }

    @Override
    public String getMessage() {
        String defaultMessage = this.messageSourceService.getMessage(super.getMessage(), super.getMessage());
        return this.messageSourceService.getMessage(this.messageKey, this.args, defaultMessage);
    }
}

