/*
 * Decompiled with CFR 0.152.
 */
package net.qimooc.commons.file.storage;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import net.qimooc.commons.file.IOUtils;

public interface FileStorage {
    public String store(String var1, InputStream var2) throws IOException;

    public InputStream read(String var1) throws IOException;

    default public String store(String path, byte[] content) throws IOException {
        if (content == null || content.length == 0) {
            throw new IllegalArgumentException("Illegal content, content must be not empty.");
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content);
        return this.store(path, inputStream);
    }

    default public String store(String path, File file) throws IOException {
        FileInputStream inputStream = null;
        try {
            if (!IOUtils.checkFile(file)) {
                throw new IllegalArgumentException("Illegal file: " + file);
            }
            inputStream = new FileInputStream(file);
            String string = this.store(path, inputStream);
            return string;
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Illegal file: " + file);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    default public String store(String path, String filePath) throws IOException {
        File tmpFile = new File(filePath);
        if (!IOUtils.checkFile(tmpFile)) {
            throw new IllegalArgumentException("Illegal file path: " + filePath);
        }
        return this.store(path, tmpFile);
    }
}

