/*
 * Decompiled with CFR 0.152.
 */
package net.qimooc.commons.file.storage;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.qimooc.commons.file.storage.FileStorage;
import net.qimooc.commons.file.storage.FileStorageConfig;
import net.qimooc.commons.file.storage.FileStorageConfigLoader;
import net.qimooc.commons.file.storage.FileStorageFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class FileStorageManager {
    private static final Logger logger = LoggerFactory.getLogger(FileStorageManager.class);
    Map<String, FileStorage> fileStorageMap = new HashMap<String, FileStorage>();
    private final FileStorageConfigLoader configLoader;
    private final List<FileStorageFactory> fileStorageFactories;

    public FileStorageManager(FileStorageConfigLoader configLoader, List<FileStorageFactory> fileStorageFactories) {
        this.configLoader = configLoader;
        this.fileStorageFactories = fileStorageFactories;
    }

    public FileStorage get(String id) {
        if (this.fileStorageMap.containsKey(id)) {
            return this.fileStorageMap.get(id);
        }
        FileStorage fileStorage = this.buildFileStorage(id);
        if (Objects.nonNull(fileStorage)) {
            this.fileStorageMap.put(id, fileStorage);
            return fileStorage;
        }
        logger.error("Build file storage failed with id {}", (Object)id);
        throw new RuntimeException("File storage of " + id + " build failed.");
    }

    public FileStorage get(FileStorageConfig config) {
        Assert.notNull((Object)config, (String)"config cannot be null");
        Assert.notNull((Object)config.getId(), (String)"config.id cannot be null");
        if (this.fileStorageMap.containsKey(config.getId())) {
            return this.fileStorageMap.get(config.getId());
        }
        FileStorage fileStorage = this.buildFileStorage(config);
        if (Objects.nonNull(fileStorage)) {
            this.fileStorageMap.put(config.getId(), fileStorage);
            return fileStorage;
        }
        logger.error("Build file storage failed with id {}", (Object)config.getId());
        throw new RuntimeException("File storage of " + config.getId() + " build failed.");
    }

    private FileStorage buildFileStorage(String id) {
        FileStorageConfig config = this.configLoader.getConfig(id);
        if (Objects.isNull(config)) {
            logger.error("File storage config of id:{} not found", (Object)id);
            throw new RuntimeException("File storage config not found. id:" + id);
        }
        return this.buildFileStorage(config);
    }

    private FileStorage buildFileStorage(FileStorageConfig config) {
        Assert.notNull((Object)config, (String)"config cannot be null");
        Optional<FileStorage> fileStorage = this.fileStorageFactories.stream().filter(f -> f.match(config.getType())).map(f -> f.buildFileStorage(config)).filter(Objects::nonNull).findFirst();
        return fileStorage.orElse(null);
    }
}

