/*
 * Decompiled with CFR 0.152.
 */
package net.qimooc.commons.file.storage.config;

import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.qimooc.commons.file.storage.FileStorage;
import net.qimooc.commons.file.storage.FileStorageConfig;
import net.qimooc.commons.file.storage.FileStorageConfigLoader;
import net.qimooc.commons.file.storage.FileStorageFactory;
import net.qimooc.commons.file.storage.FileStorageManager;
import net.qimooc.commons.file.storage.local.LocalFileStorage;
import net.qimooc.commons.file.storage.local.LocalFileStorageFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class FileStorageAutoConfiguration {
    private static final String DEFAULT_CONTENT_ROOT = "/data/content/";
    private static final String DEFAULT_CONTENT_TEMP = "/data/content/tmp";
    private static final char SEPARATOR_CHAR = '/';

    @Bean
    public FileStorageManager fileStorageManager(FileStorageConfigLoader configLoader, List<FileStorageFactory> fileStorageFactoryList) {
        List<FileStorageFactory> factories = fileStorageFactoryList.stream().filter(it -> Objects.nonNull(it.getType())).collect(Collectors.toList());
        return new FileStorageManager(configLoader, factories);
    }

    @Bean
    @ConditionalOnMissingBean(value={FileStorageConfigLoader.class})
    public FileStorageConfigLoader defaultFileStorageConfigLoader() {
        return new FileStorageConfigLoader(){

            @Override
            public FileStorageConfig getConfig(String id) {
                FileStorageConfig config = new FileStorageConfig();
                config.setId("default");
                config.setName("Default File Storage");
                config.setType(LocalFileStorage.class.getSimpleName());
                HashMap<String, Object> c = new HashMap<String, Object>();
                c.put("contentRoot", "/data/content//" + id + "/");
                config.setConfig(c);
                return config;
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean(value={LocalFileStorageFactory.class})
    public LocalFileStorageFactory localFileStorageFactory() {
        return new LocalFileStorageFactory();
    }

    @Bean
    @Primary
    @ConditionalOnMissingBean(value={FileStorage.class})
    public FileStorage defaultFileStorage() {
        return new LocalFileStorage(DEFAULT_CONTENT_ROOT);
    }

    @Configuration
    public class WebMvcConfig
    implements WebMvcConfigurer {
        public void addResourceHandlers(ResourceHandlerRegistry registry) {
            registry.addResourceHandler(new String[]{"/content/**"}).addResourceLocations(new String[]{"file:/data/content/"});
        }
    }
}

