/*
 * Decompiled with CFR 0.152.
 */
package net.qimooc.commons.file.storage.local;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.qimooc.commons.file.IOUtils;
import net.qimooc.commons.file.storage.FileStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileStorage
implements FileStorage {
    private static final Logger logger = LoggerFactory.getLogger(LocalFileStorage.class);
    public static final String DEFAULT_CONTENT_ROOT = "/data/content/";
    public static final String DEFAULT_VIRTUAL_ROOT = "/content/";
    private File contentRootDir;
    private String virtualRoot = "/content/";

    public LocalFileStorage() {
        this.contentRootDir = new File(DEFAULT_CONTENT_ROOT);
    }

    public LocalFileStorage(String contentRoot) {
        this.contentRootDir = new File(contentRoot);
    }

    @Override
    public String store(String path, InputStream inputStream) throws IOException {
        try {
            File dest = this.retrieve(path);
            IOUtils.checkDirAndCreateIfNotExists(dest.getParentFile());
            this.transferTo(inputStream, dest);
            return this.toVirtualPath(path);
        }
        catch (IOException e) {
            logger.error("Transfer file error when save file", (Throwable)e);
            throw e;
        }
    }

    @Override
    public InputStream read(String path) throws IOException {
        File file = this.retrieve(this.toRelativePath(path));
        return new FileInputStream(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transferTo(InputStream inputStream, File dest) throws IOException {
        if (dest.exists() && !dest.delete()) {
            throw new IOException("Destination file [" + dest.getAbsolutePath() + "] already exists and could not be deleted");
        }
        logger.info("Transfer to file: {}", (Object)dest.getAbsolutePath());
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(dest);
            byte[] buff = new byte[1024];
            int len = 0;
            while ((len = inputStream.read(buff)) != -1) {
                fout.write(buff, 0, len);
            }
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private File retrieve(String relativePath) {
        return new File(this.contentRootDir, relativePath);
    }

    private String toVirtualPath(String relativePath) {
        if (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        return this.virtualRoot + relativePath;
    }

    private String toRelativePath(String virtualPath) {
        return virtualPath.startsWith(this.virtualRoot) ? virtualPath.replaceFirst(this.virtualRoot, "") : virtualPath;
    }
}

