/*
 * Decompiled with CFR 0.152.
 */
package net.qimooc.commons.file.storage.local;

import net.qimooc.commons.file.storage.FileStorageConfig;
import net.qimooc.commons.file.storage.FileStorageFactory;
import net.qimooc.commons.file.storage.local.LocalFileStorage;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileStorageFactory
implements FileStorageFactory<LocalFileStorage> {
    private static final Logger logger = LoggerFactory.getLogger(LocalFileStorageFactory.class);

    @Override
    public String getType() {
        return LocalFileStorage.class.getSimpleName();
    }

    @Override
    public LocalFileStorage buildFileStorage(FileStorageConfig config) {
        if (!this.match(config.getType())) {
            return null;
        }
        String contentRoot = MapUtils.getString(config.getConfig(), (Object)"contentRoot");
        if (StringUtils.isBlank((CharSequence)contentRoot)) {
            logger.warn("the content root of local file storage is not set, using default.");
            return new LocalFileStorage();
        }
        logger.info("Build local file storage with content root: {}", (Object)contentRoot);
        return new LocalFileStorage(contentRoot);
    }
}

