/*
 * Decompiled with CFR 0.152.
 */
package net.qimooc.commons.query.builder;

import jakarta.persistence.Id;
import jakarta.persistence.Transient;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.SingularAttribute;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.qimooc.commons.exceptions.BaseException;
import net.qimooc.commons.exceptions.IllegalAnnotationError;
import net.qimooc.commons.query.annotations.QueryGreaterEqual;
import net.qimooc.commons.query.annotations.QueryGreaterThan;
import net.qimooc.commons.query.annotations.QueryLessEqual;
import net.qimooc.commons.query.annotations.QueryLessThan;
import net.qimooc.commons.query.annotations.QueryLike;
import net.qimooc.commons.query.annotations.QueryOr;
import org.reflections.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.jpa.repository.query.EscapeCharacter;
import org.springframework.data.support.ExampleMatcherAccessor;
import org.springframework.data.util.DirectFieldAccessFallbackBeanWrapper;
import org.springframework.lang.Nullable;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class DynamicQueryPredicateBuilder {
    private static final List<Class<? extends Annotation>> QUERY_ANNOTATIONS_WITHOUT_OR;
    private static final Set<Attribute.PersistentAttributeType> ASSOCIATION_TYPES;
    private static final Logger logger;

    private DynamicQueryPredicateBuilder() {
    }

    public static <T> Predicate getPredicate(Root<T> root, CriteriaBuilder cb, T entity) {
        ExampleMatcher matcher = ExampleMatcher.matching();
        return DynamicQueryPredicateBuilder.getPredicate(root, cb, entity, matcher, EscapeCharacter.DEFAULT);
    }

    public static <T> Predicate getPredicate(Root<T> root, CriteriaBuilder cb, T entity, ExampleMatcher matcher) {
        return DynamicQueryPredicateBuilder.getPredicate(root, cb, entity, matcher, EscapeCharacter.DEFAULT);
    }

    public static <T> Predicate getPredicate(Root<T> root, CriteriaBuilder cb, T entity, ExampleMatcher matcher, EscapeCharacter escapeCharacter) {
        Assert.notNull(root, (String)"Root must not be null!");
        Assert.notNull((Object)cb, (String)"CriteriaBuilder must not be null!");
        Assert.notNull((Object)matcher, (String)"Example must not be null!");
        List<Predicate> predicates = DynamicQueryPredicateBuilder.getPredicates("", cb, root, root.getModel(), entity, ClassUtils.getUserClass(entity.getClass()), matcher, new PathNode("root", null, entity), escapeCharacter);
        if (predicates.isEmpty()) {
            return cb.isTrue(cb.literal((Object)true));
        }
        if (predicates.size() == 1) {
            return predicates.iterator().next();
        }
        Predicate[] array = predicates.toArray(new Predicate[0]);
        return matcher.isAllMatching() ? cb.and(array) : cb.or(array);
    }

    static List<Predicate> getPredicates(String path, CriteriaBuilder cb, Path<?> from, ManagedType<?> type, Object entity, Class<?> probeType, ExampleMatcher matcher, PathNode currentNode, EscapeCharacter escapeCharacter) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Field idField = DynamicQueryPredicateBuilder.getIdField(entity);
        Object idFieldValue = DynamicQueryPredicateBuilder.getFieldValue(entity, idField);
        if (!StringUtils.isEmpty((Object)idFieldValue)) {
            String currentPath;
            ExampleMatcherAccessor exampleAccessorForId = new ExampleMatcherAccessor(matcher);
            String string = currentPath = !StringUtils.hasText((String)path) ? idField.getName() : path + "." + idField.getName();
            if (!exampleAccessorForId.isIgnoredPath(currentPath)) {
                predicates.add(cb.equal((Expression)from.get(idField.getName()), idFieldValue));
                return predicates;
            }
        }
        DirectFieldAccessFallbackBeanWrapper beanWrapper = new DirectFieldAccessFallbackBeanWrapper(entity);
        Set<Field> withoutOrFields = DynamicQueryPredicateBuilder.getWithoutOrFields(entity.getClass());
        Set<Field> orFields = DynamicQueryPredicateBuilder.getFieldsWithLofterOr(entity.getClass());
        matcher = DynamicQueryPredicateBuilder.getPredicateFromAnnotatedFieldsForOr(path, cb, from, entity, matcher, predicates, orFields, withoutOrFields);
        matcher = DynamicQueryPredicateBuilder.getPredicateFromAnnotatedFieldsWithoutOr(path, cb, from, entity, matcher, predicates, withoutOrFields);
        ExampleMatcherAccessor exampleAccessor = new ExampleMatcherAccessor(matcher);
        for (SingularAttribute attribute : type.getSingularAttributes()) {
            Object currentPath = !StringUtils.hasText((String)path) ? attribute.getName() : path + "." + attribute.getName();
            if (exampleAccessor.isIgnoredPath((String)currentPath)) continue;
            ExampleMatcher.PropertyValueTransformer transformer = exampleAccessor.getValueTransformerForPath((String)currentPath);
            Optional optionalValue = (Optional)transformer.apply(Optional.ofNullable(beanWrapper.getPropertyValue(attribute.getName())));
            if (!optionalValue.isPresent()) {
                if (!exampleAccessor.getNullHandler().equals((Object)ExampleMatcher.NullHandler.INCLUDE)) continue;
                predicates.add(cb.isNull((Expression)from.get(attribute)));
                continue;
            }
            Object attributeValue = optionalValue.get();
            if (attribute.getPersistentAttributeType().equals((Object)Attribute.PersistentAttributeType.EMBEDDED) || DynamicQueryPredicateBuilder.isAssociation(attribute) && !(from instanceof From)) {
                predicates.addAll(DynamicQueryPredicateBuilder.getPredicates((String)currentPath, cb, from.get(attribute.getName()), (ManagedType)attribute.getType(), attributeValue, probeType, matcher, currentNode, escapeCharacter));
                continue;
            }
            if (DynamicQueryPredicateBuilder.isAssociation(attribute)) {
                if (!(from instanceof From)) {
                    throw new JpaSystemException((RuntimeException)new IllegalArgumentException(String.format("Unexpected path type for %s. Found %s where From.class was expected.", currentPath, from)));
                }
                PathNode node = currentNode.add(attribute.getName(), attributeValue);
                if (node.spansCycle()) {
                    throw new InvalidDataAccessApiUsageException(String.format("Path '%s' from root %s must not span a cyclic property reference!\r\n%s", currentPath, ClassUtils.getShortName(probeType), node));
                }
                predicates.addAll(DynamicQueryPredicateBuilder.getPredicates((String)currentPath, cb, ((From)from).join(attribute.getName()), (ManagedType)attribute.getType(), attributeValue, probeType, matcher, node, escapeCharacter));
                continue;
            }
            if (attribute.getJavaType().equals(String.class)) {
                Path expression = from.get(attribute);
                if (exampleAccessor.isIgnoreCaseForPath((String)currentPath)) {
                    expression = cb.lower((Expression)expression);
                    attributeValue = attributeValue.toString().toLowerCase();
                }
                if (StringUtils.isEmpty(attributeValue)) continue;
                switch (exampleAccessor.getStringMatcherForPath((String)currentPath)) {
                    case DEFAULT: 
                    case EXACT: {
                        predicates.add(cb.equal((Expression)expression, attributeValue));
                        break;
                    }
                    case CONTAINING: {
                        predicates.add(cb.like((Expression)expression, "%" + escapeCharacter.escape(attributeValue.toString()) + "%", escapeCharacter.getEscapeCharacter()));
                        break;
                    }
                    case STARTING: {
                        predicates.add(cb.like((Expression)expression, escapeCharacter.escape(attributeValue.toString()) + "%", escapeCharacter.getEscapeCharacter()));
                        break;
                    }
                    case ENDING: {
                        predicates.add(cb.like((Expression)expression, "%" + escapeCharacter.escape(attributeValue.toString()), escapeCharacter.getEscapeCharacter()));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported StringMatcher " + exampleAccessor.getStringMatcherForPath((String)currentPath));
                    }
                }
                continue;
            }
            predicates.add(cb.equal((Expression)from.get(attribute), attributeValue));
        }
        return predicates;
    }

    private static Field getIdField(Object entity) {
        Set fields = ReflectionUtils.getAllFields(entity.getClass(), (com.google.common.base.Predicate[])new com.google.common.base.Predicate[]{ReflectionUtils.withAnnotation(Id.class)});
        if (!fields.iterator().hasNext()) {
            return null;
        }
        return (Field)fields.iterator().next();
    }

    private static ExampleMatcher getPredicateFromAnnotatedFieldsForOr(String path, CriteriaBuilder cb, Path<?> from, Object entity, ExampleMatcher matcher, List<Predicate> predicates, Set<Field> orFields, Set<Field> withoutOrFields) {
        HashSet<Field> excludeFields = new HashSet<Field>();
        for (Field field : orFields) {
            if (!field.isAnnotationPresent(Transient.class)) {
                throw new BaseException("QueryOr annotation must be used with 'jakarta.persistence.Transient'");
            }
            if (!field.getType().toString().endsWith("String")) {
                throw new BaseException("QueryOr annotation must be used on 'java.lang.String'");
            }
            Object filterValue = DynamicQueryPredicateBuilder.getFieldValue(entity, field);
            if (StringUtils.isEmpty((Object)filterValue)) continue;
            String filterStringValue = "" + filterValue;
            QueryOr ann = (QueryOr)AnnotationUtils.findAnnotation((AnnotatedElement)field, QueryOr.class);
            String[] targets = ann.target();
            ArrayList<Predicate> orPredicates = new ArrayList<Predicate>();
            block7: for (String targetName : targets) {
                Field targetField;
                if (StringUtils.isEmpty((Object)targetName) || (targetField = DynamicQueryPredicateBuilder.getFieldByName(entity, targetName)) == null) continue;
                excludeFields.add(targetField);
                matcher = matcher.withIgnorePaths(new String[]{!StringUtils.hasText((String)path) ? targetField.getName() : path + "." + targetField.getName()});
                QueryLike queryLike = (QueryLike)AnnotationUtils.findAnnotation((AnnotatedElement)targetField, QueryLike.class);
                if (queryLike != null) {
                    switch (queryLike.matcher()) {
                        case DEFAULT: 
                        case EXACT: {
                            orPredicates.add(cb.equal(cb.lower((Expression)from.get(targetField.getName())), (Object)filterStringValue));
                            continue block7;
                        }
                        case CONTAINING: {
                            orPredicates.add(cb.like(cb.lower((Expression)from.get(targetField.getName())), "%" + filterStringValue.toLowerCase() + "%"));
                            continue block7;
                        }
                        case STARTING: {
                            orPredicates.add(cb.like(cb.lower((Expression)from.get(targetField.getName())), filterStringValue.toLowerCase() + "%"));
                            continue block7;
                        }
                        case ENDING: {
                            orPredicates.add(cb.like(cb.lower((Expression)from.get(targetField.getName())), "%" + filterStringValue.toLowerCase()));
                            continue block7;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported StringMatcher ");
                        }
                    }
                }
                orPredicates.add(cb.like(cb.lower((Expression)from.get(targetField.getName())), "%" + filterStringValue.toLowerCase() + "%"));
            }
            if (orPredicates.isEmpty()) continue;
            Predicate[] orps = new Predicate[orPredicates.size()];
            predicates.add(cb.or(orPredicates.toArray(orps)));
        }
        withoutOrFields.removeAll(excludeFields);
        return matcher;
    }

    private static Field getFieldByName(Object entity, String targetName) {
        Set fields = ReflectionUtils.getAllFields(entity.getClass(), (com.google.common.base.Predicate[])new com.google.common.base.Predicate[]{ReflectionUtils.withName((String)targetName)});
        if (!fields.iterator().hasNext()) {
            return null;
        }
        return (Field)fields.iterator().next();
    }

    private static Object getFieldValue(Object value, Field field) {
        field.setAccessible(true);
        Object val = null;
        try {
            val = field.get(value);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return val;
    }

    private static ExampleMatcher getPredicateFromAnnotatedFieldsWithoutOr(String path, CriteriaBuilder cb, Path<?> from, Object value, ExampleMatcher matcher, List<Predicate> predicates, Set<Field> annotatedfields) {
        block6: for (Field field : annotatedfields) {
            Predicate predicate;
            String target;
            Object targetValue;
            Annotation ann;
            if (field != null && field.isAnnotationPresent(QueryLike.class)) {
                ann = (QueryLike)AnnotationUtils.findAnnotation((AnnotatedElement)field, QueryLike.class);
                field.setAccessible(true);
                Object val = DynamicQueryPredicateBuilder.getFieldValue(value, field);
                if (!field.getType().toString().endsWith("String")) {
                    throw new IllegalAnnotationError("Annotation \"@QueryLike\" was used on field \"" + field.getName() + "\" which is unsupported!");
                }
                if (StringUtils.isEmpty((Object)val)) continue;
                matcher = matcher.withIgnorePaths(new String[]{!StringUtils.hasText((String)path) ? field.getName() : path + "." + field.getName()});
                String fieldStringVal = "" + val;
                switch (ann.matcher()) {
                    case DEFAULT: 
                    case EXACT: {
                        predicates.add(cb.equal(cb.lower((Expression)from.get(field.getName())), (Object)fieldStringVal));
                        continue block6;
                    }
                    case CONTAINING: {
                        predicates.add(cb.like(cb.lower((Expression)from.get(field.getName())), "%" + fieldStringVal.toLowerCase() + "%"));
                        continue block6;
                    }
                    case STARTING: {
                        predicates.add(cb.like(cb.lower((Expression)from.get(field.getName())), fieldStringVal.toLowerCase() + "%"));
                        continue block6;
                    }
                    case ENDING: {
                        predicates.add(cb.like(cb.lower((Expression)from.get(field.getName())), "%" + fieldStringVal.toLowerCase()));
                        continue block6;
                    }
                }
                throw new IllegalArgumentException("Unsupported StringMatcher ");
            }
            if (field != null && field.isAnnotationPresent(QueryGreaterEqual.class) && !StringUtils.isEmpty((Object)(targetValue = DynamicQueryPredicateBuilder.processComparable(value, field, target = (ann = (QueryGreaterEqual)AnnotationUtils.findAnnotation((AnnotatedElement)field, QueryGreaterEqual.class)).target())))) {
                predicate = cb.greaterThanOrEqualTo((Expression)from.get(field.getName()), (Comparable)targetValue);
                predicates.add(predicate);
                matcher = matcher.withIgnorePaths(new String[]{!StringUtils.hasText((String)path) ? field.getName() : path + "." + field.getName()});
            }
            if (field != null && field.isAnnotationPresent(QueryGreaterThan.class) && !StringUtils.isEmpty((Object)(targetValue = DynamicQueryPredicateBuilder.processComparable(value, field, target = (ann = (QueryGreaterThan)AnnotationUtils.findAnnotation((AnnotatedElement)field, QueryGreaterThan.class)).target())))) {
                predicate = cb.greaterThan((Expression)from.get(field.getName()), (Comparable)targetValue);
                predicates.add(predicate);
                matcher = matcher.withIgnorePaths(new String[]{!StringUtils.hasText((String)path) ? field.getName() : path + "." + field.getName()});
            }
            if (field != null && field.isAnnotationPresent(QueryLessEqual.class) && !StringUtils.isEmpty((Object)(targetValue = DynamicQueryPredicateBuilder.processComparable(value, field, target = (ann = (QueryLessEqual)AnnotationUtils.findAnnotation((AnnotatedElement)field, QueryLessEqual.class)).target())))) {
                predicate = cb.lessThanOrEqualTo((Expression)from.get(field.getName()), (Comparable)targetValue);
                predicates.add(predicate);
                matcher = matcher.withIgnorePaths(new String[]{!StringUtils.hasText((String)path) ? field.getName() : path + "." + field.getName()});
            }
            if (field == null || !field.isAnnotationPresent(QueryLessThan.class) || !StringUtils.isEmpty((Object)(targetValue = DynamicQueryPredicateBuilder.processComparable(value, field, target = (ann = (QueryLessThan)AnnotationUtils.findAnnotation((AnnotatedElement)field, QueryLessThan.class)).target())))) continue;
            predicate = cb.lessThan((Expression)from.get(field.getName()), (Comparable)targetValue);
            predicates.add(predicate);
            matcher.withIgnorePaths(new String[]{!StringUtils.hasText((String)path) ? field.getName() : path + "." + field.getName()});
        }
        return matcher;
    }

    private static Object processComparable(Object value, Field field, String target) {
        if (StringUtils.isEmpty((Object)target)) {
            logger.info("\u672a\u627e\u5230 {} \u9700\u8981\u6bd4\u8f83\u7684\u5b57\u6bb5,\u8df3\u8fc7\u6784\u9020\u8fc7\u6ee4\u6761\u4ef6", (Object)field.getName());
            field.setAccessible(true);
            return DynamicQueryPredicateBuilder.getFieldValue(value, field);
        }
        Set fields = ReflectionUtils.getAllFields(value.getClass(), (com.google.common.base.Predicate[])new com.google.common.base.Predicate[]{ReflectionUtils.withName((String)target)});
        if (!fields.iterator().hasNext()) {
            return null;
        }
        Field targetField = (Field)fields.iterator().next();
        Object targetValue = null;
        try {
            targetField.setAccessible(true);
            targetValue = targetField.get(value);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return targetValue;
    }

    private static Set<Field> getWithoutOrFields(Class<?> probeType) {
        HashSet<Field> withoutOrFields = new HashSet<Field>();
        for (Class<? extends Annotation> annotation : QUERY_ANNOTATIONS_WITHOUT_OR) {
            withoutOrFields.addAll(ReflectionUtils.getAllFields(probeType, (com.google.common.base.Predicate[])new com.google.common.base.Predicate[]{ReflectionUtils.withAnnotation(annotation)}));
        }
        return withoutOrFields;
    }

    private static Set<Field> getFieldsWithLofterOr(Class<?> probeType) {
        HashSet<Field> orFields = new HashSet<Field>();
        orFields.addAll(ReflectionUtils.getAllFields(probeType, (com.google.common.base.Predicate[])new com.google.common.base.Predicate[]{ReflectionUtils.withAnnotation(QueryOr.class)}));
        return orFields;
    }

    private static boolean isAssociation(Attribute<?, ?> attribute) {
        return ASSOCIATION_TYPES.contains(attribute.getPersistentAttributeType());
    }

    static {
        logger = LoggerFactory.getLogger(DynamicQueryPredicateBuilder.class);
        ASSOCIATION_TYPES = new HashSet<Attribute.PersistentAttributeType>(Arrays.asList(Attribute.PersistentAttributeType.MANY_TO_MANY, Attribute.PersistentAttributeType.MANY_TO_ONE, Attribute.PersistentAttributeType.ONE_TO_MANY, Attribute.PersistentAttributeType.ONE_TO_ONE));
        QUERY_ANNOTATIONS_WITHOUT_OR = Arrays.asList(QueryLike.class, QueryGreaterEqual.class, QueryGreaterThan.class, QueryLessEqual.class, QueryLessThan.class);
    }

    private static class PathNode {
        String name;
        @Nullable
        PathNode parent;
        List<PathNode> siblings = new ArrayList<PathNode>();
        @Nullable
        Object value;

        PathNode(String edge, @Nullable PathNode parent, @Nullable Object value) {
            this.name = edge;
            this.parent = parent;
            this.value = value;
        }

        PathNode add(String attribute, @Nullable Object value) {
            PathNode node = new PathNode(attribute, this, value);
            this.siblings.add(node);
            return node;
        }

        boolean spansCycle() {
            if (this.value == null) {
                return false;
            }
            String identityHex = ObjectUtils.getIdentityHexString((Object)this.value);
            PathNode current = this.parent;
            while (current != null) {
                if (current.value != null && ObjectUtils.getIdentityHexString((Object)current.value).equals(identityHex)) {
                    return true;
                }
                current = current.parent;
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.parent != null) {
                sb.append(this.parent.toString());
                sb.append(" -");
                sb.append(this.name);
                sb.append("-> ");
            }
            sb.append("[{ ");
            sb.append(ObjectUtils.nullSafeToString((Object)this.value));
            sb.append(" }]");
            return sb.toString();
        }
    }
}

