/*
 * Decompiled with CFR 0.152.
 */
package net.qimooc.commons.query.mybatis.interceptor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.qimooc.commons.exceptions.BusinessException;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class SortParamTranslatorInterceptor
implements Interceptor {
    static int MAPPED_STATEMENT_INDEX = 0;
    static int PARAMETER_INDEX = 1;
    static int ROWBOUNDS_INDEX = 2;
    static int RESULT_HANDLER_INDEX = 3;
    private static Pattern safeParameterPattern = Pattern.compile("[A-Za-z]+[A-Za-z0-9,_]*");
    static ExecutorService pool;
    String dialectClass;
    boolean asyncTotalCount = false;
    private static Pattern humpPattern;

    public Object intercept(Invocation invocation) throws Throwable {
        Object[] queryArgs = invocation.getArgs();
        Object prefParameter = queryArgs[PARAMETER_INDEX];
        if (!(prefParameter instanceof HashMap)) {
            return invocation.proceed();
        }
        HashMap params = (HashMap)prefParameter;
        for (Map.Entry entry : params.entrySet()) {
            if (entry.getValue() == null || !(entry.getValue() instanceof Pageable)) continue;
            Pageable pageable = (Pageable)entry.getValue();
            ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
            Sort sort = pageable.getSort();
            if (pageable.getSort() != null) {
                for (Sort.Order order : sort) {
                    if (!safeParameterPattern.matcher(order.getProperty()).matches()) {
                        throw new BusinessException("\u975e\u6cd5\u7684\u8bf7\u6c42\u53c2\u6570");
                    }
                    orders.add(new Sort.Order(order.getDirection(), this.camelToUnderline(order.getProperty())));
                }
            }
            PageRequest pageRequest = null;
            pageRequest = orders != null && orders.size() > 0 ? PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)Sort.by(orders)) : PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize());
            entry.setValue(pageRequest);
        }
        return invocation.proceed();
    }

    private String camelToUnderline(CharSequence str) {
        Matcher matcher = humpPattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    static {
        humpPattern = Pattern.compile("[A-Z]");
    }
}

