/*
 * Decompiled with CFR 0.152.
 */
package net.qimooc.commons.service;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import jakarta.persistence.criteria.Expression;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.Optional;
import net.qimooc.commons.entity.EntityMapper;
import net.qimooc.commons.entity.Repairable;
import net.qimooc.commons.exceptions.BusinessException;
import net.qimooc.commons.repository.SupportRepository;
import net.qimooc.commons.service.NewCrudService;
import net.qimooc.commons.service.QuerydslPredicateService;
import net.qimooc.commons.service.SpecificationQueryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.util.Assert;

public abstract class CrudBaseService<M, E, ID extends Serializable, REPO extends SupportRepository<E, ID>, MAPPER extends EntityMapper<M, E>>
implements NewCrudService<M, E, ID>,
SpecificationQueryService<M, E>,
QuerydslPredicateService<M, E> {
    private static final Logger logger = LoggerFactory.getLogger(CrudBaseService.class);
    protected REPO repository;
    protected MAPPER entityMapper;
    private Class<E> entityClazz;
    protected boolean isRepairable = false;

    public CrudBaseService() {
        Class clazz;
        this.entityClazz = clazz = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[1];
        this.isRepairable = Repairable.class.isAssignableFrom(clazz);
    }

    @Autowired
    public <S extends REPO> void setRepository(S repository) {
        this.repository = repository;
    }

    @Override
    public REPO getRepository() {
        return this.repository;
    }

    @Autowired
    public <S extends MAPPER> void setEntityMapper(S entityMapper) {
        this.entityMapper = entityMapper;
    }

    @Override
    public MAPPER getEntityMapper() {
        return this.entityMapper;
    }

    @Override
    public void delete(ID id, boolean isPhysical) {
        Assert.notNull(id, (String)"id cannot be null");
        if (this.isRepairable && !isPhysical) {
            Optional entityOptional = this.getRepository().findById(id);
            if (entityOptional.isEmpty()) {
                throw new BusinessException("Not found by id: " + id);
            }
            Object entity = entityOptional.get();
            this.tagDelete(entity);
        } else {
            this.getRepository().deleteById(id);
        }
    }

    protected void tagDelete(E entity) {
        if (null == entity) {
            return;
        }
        if (this.isRepairable) {
            try {
                ((Repairable)entity).setIsDeleted(true);
                this.getRepository().saveAndFlush(entity);
            }
            catch (ClassCastException e) {
                throw new RuntimeException("The given class " + entity.getClass() + " is not a Repairable(" + Repairable.class + ") class");
            }
        } else {
            throw new RuntimeException("The given class " + entity.getClass() + " is not a Repairable(" + Repairable.class + ") class");
        }
    }

    @Deprecated
    public Specification notDeleted(Specification specification) {
        if (this.isRepairable) {
            return specification.and((Specification & Serializable)(root, query, builder) -> builder.isFalse((Expression)root.get("isDeleted")));
        }
        return specification;
    }

    @Deprecated
    public Predicate notDeleted(BooleanBuilder builder, EntityPath<E> entityPath) {
        if (this.isRepairable) {
            builder.and((Predicate)Expressions.booleanPath(entityPath, (String)"isDeleted").isFalse());
        }
        return builder;
    }
}

