/*
 * Decompiled with CFR 0.152.
 */
package net.qimooc.commons.service;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.qimooc.commons.entity.EntityMapper;
import net.qimooc.commons.exceptions.BusinessException;
import net.qimooc.commons.exceptions.NotFoundException;
import net.qimooc.commons.service.Updatable;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.util.Assert;

public interface NewCrudService<M, E, ID extends Serializable> {
    public <REPO extends JpaRepository<E, ID>> REPO getRepository();

    public <MAPPER extends EntityMapper<M, E>> MAPPER getEntityMapper();

    default public M create(M model) {
        Assert.notNull(model, (String)"model cannot be null");
        Object entity = this.getEntityMapper().toEntity(model);
        entity = this.getRepository().save(entity);
        return this.getEntityMapper().toModel(entity);
    }

    default public Collection<M> create(Collection<M> models) {
        Assert.notNull(models, (String)"model cannot be null");
        return models.stream().filter(Objects::nonNull).map(this::create).collect(Collectors.toList());
    }

    default public M update(ID id, M model) {
        Assert.notNull(id, (String)"id cannot be null");
        Assert.notNull(model, (String)"model cannot be null");
        return this.update(id, (E entity) -> this.getEntityMapper().updateEntity(model, (Object)entity));
    }

    default public M update(ID id, Map<String, Object> model) {
        Assert.notNull(id, (String)"id cannot be null");
        Assert.notNull(model, (String)"model cannot be null");
        return this.update(id, (E entity) -> {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                objectMapper.readerForUpdating(entity).without(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).readValue(objectMapper.writeValueAsBytes((Object)model));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    default public M update(ID id, Updatable<E> updatable) {
        Assert.notNull(id, (String)"id cannot be null");
        Assert.notNull(updatable, (String)"updatable cannot be null");
        Object entity = this.getRepository().findById(id).orElseThrow(() -> new NotFoundException("Entity of " + id + "not found"));
        updatable.update(entity);
        this.validateUpdate(entity);
        entity = this.getRepository().save(entity);
        return this.getEntityMapper().toModel(entity);
    }

    default public void validateUpdate(E entity) {
    }

    default public void delete(ID id) {
        this.delete(id, false);
    }

    default public void delete(Collection<ID> ids) {
        this.delete(ids, false);
    }

    public void delete(ID var1, boolean var2);

    default public void delete(Collection<ID> ids, boolean isPhysical) {
        Assert.notNull(ids, (String)"ids cannot be null");
        ids.stream().filter(Objects::nonNull).forEach(id -> this.delete(id, isPhysical));
    }

    default public void delete(ID[] ids, boolean isPhysical) {
        this.delete((Collection<ID>)Arrays.asList(ids), isPhysical);
    }

    default public long count() {
        return this.getRepository().count();
    }

    default public long count(M model) {
        Assert.notNull(model, (String)"model cannot be null");
        Object entity = this.getEntityMapper().toEntity(model);
        return this.getRepository().count(Example.of(entity));
    }

    default public boolean exists(ID id) {
        Assert.notNull(id, (String)"id cannot be null");
        return this.getRepository().existsById(id);
    }

    default public boolean exists(M model) {
        Assert.notNull(model, (String)"model cannot be null");
        Object entity = this.getEntityMapper().toEntity(model);
        return this.getRepository().exists(Example.of(entity));
    }

    default public Optional<M> findById(ID id) {
        Assert.notNull(id, (String)"id cannot be null");
        return this.getRepository().findById(id).map(arg_0 -> this.getEntityMapper().toModel(arg_0));
    }

    default public Optional<M> findOne(M model) {
        Assert.notNull(model, (String)"model cannot be null");
        Object entity = this.getEntityMapper().toEntity(model);
        return this.getRepository().findOne(Example.of(entity)).map(arg_0 -> this.getEntityMapper().toModel(arg_0));
    }

    default public Stream<M> findAll() {
        return this.getRepository().findAll().stream().map(arg_0 -> this.getEntityMapper().toModel(arg_0));
    }

    default public Page<M> findAll(Pageable pageable) {
        Assert.notNull((Object)pageable, (String)"pageable cannot be null");
        return this.getRepository().findAll(pageable).map(arg_0 -> this.getEntityMapper().toModel(arg_0));
    }

    default public Stream<M> findAll(Collection<ID> ids) {
        Assert.notNull(ids, (String)"ids cannot be null");
        if (ids.size() > 2000) {
            throw new BusinessException("\u5355\u6b21\u67e5\u8be2\u8d85\u8fc72000\u884c");
        }
        return this.getRepository().findAllById(ids).stream().map(arg_0 -> this.getEntityMapper().toModel(arg_0));
    }

    default public Stream<M> findAll(M model) {
        Assert.notNull(model, (String)"modal cannot be null");
        Object entity = this.getEntityMapper().toEntity(model);
        return this.getRepository().findAll(Example.of(entity)).stream().map(arg_0 -> this.getEntityMapper().toModel(arg_0));
    }

    default public Page<M> findAll(M model, Pageable pageable) {
        Assert.notNull(model, (String)"modal cannot be null");
        Object entity = this.getEntityMapper().toEntity(model);
        Page page = this.getRepository().findAll(Example.of(entity), pageable);
        List models = page.stream().map(arg_0 -> this.getEntityMapper().toModel(arg_0)).collect(Collectors.toList());
        return new PageImpl(models, page.getPageable(), page.getTotalElements());
    }

    default public Pageable fallbackSort(Pageable pageable, Sort.Direction direction, String property) {
        Sort sort = pageable.getSort();
        if (Objects.isNull(sort.getOrderFor(property))) {
            sort = sort.and(Sort.by((Sort.Direction)direction, (String[])new String[]{property}));
            pageable = PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)sort);
        }
        return pageable;
    }
}

