/*
 * Decompiled with CFR 0.152.
 */
package net.qimooc.commons.service;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.qimooc.commons.entity.EntityMapper;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.lang.Nullable;

public interface SpecificationQueryService<M, E> {
    public <REPO extends JpaSpecificationExecutor<E>> REPO getRepository();

    public <MAPPER extends EntityMapper<M, E>> MAPPER getEntityMapper();

    default public Optional<M> findOne(@Nullable Specification<E> spec) {
        return this.getRepository().findOne(spec).map(arg_0 -> this.getEntityMapper().toModel(arg_0));
    }

    default public List<M> findAll(@Nullable Specification<E> spec) {
        return this.getRepository().findAll(spec).stream().map(arg_0 -> this.getEntityMapper().toModel(arg_0)).collect(Collectors.toList());
    }

    default public Page<M> findAll(@Nullable Specification<E> spec, Pageable pageable) {
        return this.getRepository().findAll(spec, pageable).map(arg_0 -> this.getEntityMapper().toModel(arg_0));
    }

    default public List<M> findAll(@Nullable Specification<E> spec, Sort sort) {
        return this.getRepository().findAll(spec, sort).stream().map(arg_0 -> this.getEntityMapper().toModel(arg_0)).collect(Collectors.toList());
    }

    default public long count(@Nullable Specification<E> spec) {
        return this.getRepository().count(spec);
    }
}

