/*
 * Decompiled with CFR 0.152.
 */
package net.qimooc.commons.spring.support;

import java.text.ParseException;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

@Component
public class DateConvert
implements Converter<String, Date> {
    private static String[] parsePatterns = new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM", "HH:mm:ss", "HH:mm", "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyy/MM", "yyyy.MM.dd", "yyyy.MM.dd HH:mm:ss", "yyyy.MM.dd HH:mm", "yyyy.MM"};

    public Date convert(String source) {
        Date date = null;
        try {
            if (NumberUtils.isCreatable((String)source)) {
                date = new Date(NumberUtils.createLong((String)source));
            } else {
                if (StringUtils.isBlank((CharSequence)source)) {
                    return null;
                }
                date = DateUtils.parseDate((String)source, (String[])parsePatterns);
            }
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return date;
    }
}

