/*
 * Decompiled with CFR 0.152.
 */
package net.qimooc.commons.utils;

import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.qimooc.commons.utils.IllegalArguments;

public class Base62 {
    private static final BigInteger BASE = BigInteger.valueOf(62L);

    public static BigInteger decode(String base62String) {
        return Base62.decode(base62String, StandardCharsets.UTF_8);
    }

    public static BigInteger decode(String base62String, Charset charset) {
        IllegalArguments.ensureNotNull("Base62 String", base62String);
        IllegalArguments.ensureNotNull("Charset", charset);
        return Base62.decode(base62String.getBytes(charset));
    }

    public static int decodeInt(String base62String) throws ArithmeticException {
        return Base62.decodeInt(base62String, StandardCharsets.UTF_8);
    }

    public static int decodeInt(String base62String, Charset charset) throws ArithmeticException {
        IllegalArguments.ensureNotNull("Base62 String", base62String);
        IllegalArguments.ensureNotNull("Charset", charset);
        return Base62.decode(base62String.getBytes(charset)).intValueExact();
    }

    public static long decodeLong(String base62String) throws ArithmeticException {
        return Base62.decodeLong(base62String, StandardCharsets.UTF_8);
    }

    public static long decodeLong(String base62String, Charset charset) throws ArithmeticException {
        IllegalArguments.ensureNotNull("Base62 String", base62String);
        IllegalArguments.ensureNotNull("Charset", charset);
        return Base62.decode(base62String.getBytes(charset)).longValueExact();
    }

    public static byte[] decodeBytes(String base62String) throws ArithmeticException {
        return Base62.decodeBytes(base62String, StandardCharsets.UTF_8);
    }

    public static byte[] decodeBytes(String base62String, Charset charset) throws ArithmeticException {
        IllegalArguments.ensureNotNull("Base62 String", base62String);
        IllegalArguments.ensureNotNull("Charset", charset);
        return Base62.decode(base62String.getBytes(charset)).toByteArray();
    }

    private static BigInteger decode(byte[] base62Bytes) {
        BigInteger res = BigInteger.ZERO;
        BigInteger multiplier = BigInteger.ONE;
        for (int i = base62Bytes.length - 1; i >= 0; --i) {
            res = res.add(multiplier.multiply(BigInteger.valueOf(Base62.alphabetValueOf(base62Bytes[i]))));
            multiplier = multiplier.multiply(BASE);
        }
        return res;
    }

    private static int alphabetValueOf(byte bytee) {
        if (Character.isLowerCase(bytee)) {
            return bytee - 87;
        }
        if (Character.isUpperCase(bytee)) {
            return bytee - 29;
        }
        return bytee - 48;
    }

    public static String encode(Integer number) {
        IllegalArguments.ensureNotNull("Number", number);
        return Base62.encode(new BigInteger(number.toString()));
    }

    public static String encode(Long number) {
        IllegalArguments.ensureNotNull("Number", number);
        return Base62.encode(new BigInteger(number.toString()));
    }

    public static String encode(byte[] bytes) {
        IllegalArguments.ensureNotNull("Bytes", bytes);
        IllegalArguments.ensureNotEmpty("Bytes", bytes);
        return Base62.encode(new BigInteger(bytes));
    }

    public static String encode(BigInteger number) {
        IllegalArguments.ensureNotNull("Number", number);
        IllegalArguments.ensureGreater("Number", number, BigInteger.ZERO);
        if (BigInteger.ZERO.compareTo(number) == 0) {
            return "0";
        }
        BigInteger value = number.add(BigInteger.ZERO);
        StringBuilder sb = new StringBuilder();
        while (BigInteger.ZERO.compareTo(value) < 0) {
            BigInteger[] quotientReminder = value.divideAndRemainder(BASE);
            int remainder = quotientReminder[1].intValue();
            if (remainder < 10) {
                sb.insert(0, (char)(remainder + 48));
            } else if (remainder < 36) {
                sb.insert(0, (char)(remainder + 97 - 10));
            } else {
                sb.insert(0, (char)(remainder + 65 - 10 - 26));
            }
            value = quotientReminder[0];
        }
        return sb.toString();
    }

    private Base62() {
    }
}

