/*
 * Decompiled with CFR 0.152.
 */
package net.qimooc.commons.utils;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanUtils
extends BeanUtilsBean {
    private static final Logger log = LoggerFactory.getLogger(BeanUtils.class);

    public void copyProperties(Object dest, Object orig, boolean ignoreNullFlag) throws IllegalAccessException, InvocationTargetException {
        if (dest == null) {
            throw new IllegalArgumentException("No destination bean specified");
        }
        if (orig == null) {
            throw new IllegalArgumentException("No origin bean specified");
        }
        if (log.isDebugEnabled()) {
            log.debug("BeanUtils.copyProperties(" + dest + ", " + orig + "," + ignoreNullFlag + ")");
        }
        if (orig instanceof DynaBean) {
            DynaProperty[] origDescriptors = ((DynaBean)orig).getDynaClass().getDynaProperties();
            for (int i = 0; i < origDescriptors.length; ++i) {
                String name = origDescriptors[i].getName();
                if (!this.getPropertyUtils().isReadable(orig, name) || !this.getPropertyUtils().isWriteable(dest, name)) continue;
                Object value = ((DynaBean)orig).get(name);
                if (ignoreNullFlag) {
                    if (value == null) continue;
                    this.copyProperty(dest, name, value);
                    continue;
                }
                this.copyProperty(dest, name, value);
            }
        } else if (orig instanceof Map) {
            Map propMap = (Map)orig;
            for (Map.Entry entry : propMap.entrySet()) {
                String name = (String)entry.getKey();
                Object value = entry.getValue();
                if (!this.getPropertyUtils().isWriteable(dest, name)) continue;
                if (ignoreNullFlag) {
                    if (value == null) continue;
                    this.copyProperty(dest, name, value);
                    continue;
                }
                this.copyProperty(dest, name, value);
            }
        } else {
            PropertyDescriptor[] origDescriptors = this.getPropertyUtils().getPropertyDescriptors(orig);
            for (int i = 0; i < origDescriptors.length; ++i) {
                String name = origDescriptors[i].getName();
                if ("class".equals(name) || !this.getPropertyUtils().isReadable(orig, name) || !this.getPropertyUtils().isWriteable(dest, name)) continue;
                try {
                    Object value = this.getPropertyUtils().getSimpleProperty(orig, name);
                    if (ignoreNullFlag) {
                        if (value == null) continue;
                        this.copyProperty(dest, name, value);
                        continue;
                    }
                    this.copyProperty(dest, name, value);
                    continue;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
    }
}

