/*
 * Decompiled with CFR 0.152.
 */
package net.qimooc.commons.utils;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;

public final class IllegalArguments {
    private static final String WAS_NULL = " was null.";
    private static final String WAS_EMPTY = " was empty.";
    private static final String WAS_ZERO = " was zero.";

    public static void ensureNotNull(String name, Object value) {
        if (value != null) {
            return;
        }
        throw new IllegalArgumentException(name + WAS_NULL);
    }

    public static void ensureNotEmpty(String name, String value) {
        IllegalArguments.ensureNotNull(name, value);
        if (value.length() == 0) {
            throw new IllegalArgumentException(name + WAS_EMPTY);
        }
    }

    public static void ensureNotEmpty(String name, CharSequence value) {
        IllegalArguments.ensureNotNull(name, value);
        if (value.length() == 0) {
            throw new IllegalArgumentException(name + WAS_EMPTY);
        }
    }

    public static void ensureNotEmpty(String name, boolean trim, String value) {
        IllegalArguments.ensureNotNull(name, value);
        if (value.length() == 0 || trim && value.trim().length() == 0) {
            throw new IllegalArgumentException(name + WAS_EMPTY);
        }
    }

    public static void ensureNotEmpty(String name, Object[] value) {
        IllegalArguments.ensureNotNull(name, value);
        if (value.length == 0) {
            throw new IllegalArgumentException(name + WAS_EMPTY);
        }
    }

    public static void ensureNotEmpty(String name, byte[] value) {
        IllegalArguments.ensureNotNull(name, value);
        if (value.length == 0) {
            throw new IllegalArgumentException(name + WAS_EMPTY);
        }
    }

    public static void ensureNotEmpty(String name, Collection<?> value) {
        IllegalArguments.ensureNotNull(name, value);
        if (value.isEmpty()) {
            throw new IllegalArgumentException(name + WAS_EMPTY);
        }
    }

    public static void ensureNotEmpty(String name, Properties value) {
        IllegalArguments.ensureNotNull(name, value);
        if (value.isEmpty()) {
            throw new IllegalArgumentException(name + WAS_EMPTY);
        }
    }

    public static void ensureNotEmpty(String name, Map<?, ?> value) {
        IllegalArguments.ensureNotNull(name, value);
        if (value.isEmpty()) {
            throw new IllegalArgumentException(name + WAS_EMPTY);
        }
    }

    public static void ensureNotEmptyContent(String name, String[] value) {
        IllegalArguments.ensureNotEmptyContent(name, false, value);
    }

    public static void ensureNotEmptyContent(String name, boolean trim, String[] value) {
        IllegalArguments.ensureNotEmpty(name, value);
        for (int i = 0; i < value.length; ++i) {
            IllegalArguments.ensureNotEmpty(value[i] + "[" + i + "]", value[i]);
            if (!trim) continue;
            IllegalArguments.ensureNotEmpty(value[i] + "[" + i + "]", value[i].trim());
        }
    }

    public static void ensureNotZero(String name, Integer value) {
        IllegalArguments.ensureNotNull(name, value);
        if (value == 0) {
            throw new IllegalArgumentException(name + WAS_ZERO);
        }
    }

    public static void ensureInRange(String name, Integer value, Integer from, Integer to) {
        IllegalArguments.ensureNotNull(name, value);
        if (value < from || value > to) {
            throw new IllegalArgumentException(name + " was not in range [" + from + "," + to + "].");
        }
    }

    public static void ensureGreaterOrEqual(String name, Integer value, Integer lower) {
        IllegalArguments.ensureNotNull(name, value);
        if (value < lower) {
            throw new IllegalArgumentException(name + " was lesser than " + lower);
        }
    }

    public static void ensureGreater(String name, Integer value, Integer lower) {
        IllegalArguments.ensureNotNull(name, value);
        if (value <= lower) {
            throw new IllegalArgumentException(name + " was lesser than or equal to " + lower);
        }
    }

    public static void ensureGreater(String name, BigInteger value, BigInteger lower) {
        IllegalArguments.ensureNotNull(name, value);
        if (lower.compareTo(value) > 0) {
            throw new IllegalArgumentException(name + " was lesser than or equal to " + lower);
        }
    }

    public static void ensureLesser(String name, Integer value, Integer higher) {
        IllegalArguments.ensureNotNull(name, value);
        if (value >= higher) {
            throw new IllegalArgumentException(name + " was higher than or equal to " + higher);
        }
    }

    public static void ensureLesserOrEqual(String name, Integer value, Integer higher) {
        IllegalArguments.ensureNotNull(name, value);
        if (value > higher) {
            throw new IllegalArgumentException(name + " was higher than " + higher);
        }
    }

    private IllegalArguments() {
    }
}

