/*
 * Decompiled with CFR 0.152.
 */
package net.qimooc.commons.web.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import net.qimooc.commons.utils.ThreadLocalUtils;
import net.qimooc.commons.utils.network.IpAddressUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ClientRealIpFilter
implements Filter {
    public static final String THREADLOCAL_USER_REAL_IP = "threadlocal_user_real_ip";
    private static final Logger logger = LoggerFactory.getLogger(ClientRealIpFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String clientRealIp = IpAddressUtil.getClientRealIp((HttpServletRequest)request);
        logger.debug(">>>>>>>>>>>> client real ip is : " + clientRealIp);
        ThreadLocalUtils.put(THREADLOCAL_USER_REAL_IP, clientRealIp);
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

