/*
 * Decompiled with CFR 0.152.
 */
package net.qimooc.thematic.thymeleaf.spring5.configuration;

import java.util.Objects;
import net.qimooc.thematic.thymeleaf.configuration.AbstractThematicThymeleafResolverBuilder;
import net.qimooc.thematic.thymeleaf.spring5.resolver.SpringResourceThematicTemplateResolver;
import org.springframework.boot.autoconfigure.thymeleaf.ThymeleafProperties;
import org.springframework.context.ApplicationContext;

public class SpringResourceThematicThymeleafResolverBuilder
extends AbstractThematicThymeleafResolverBuilder<SpringResourceThematicThymeleafResolverBuilder, SpringResourceThematicTemplateResolver> {
    private ThymeleafProperties thymeleafProperties;
    private ApplicationContext applicationContext;

    public SpringResourceThematicThymeleafResolverBuilder thymeleafProperties(ThymeleafProperties thymeleafProperties) {
        this.thymeleafProperties = thymeleafProperties;
        return this;
    }

    public SpringResourceThematicThymeleafResolverBuilder applicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        return this;
    }

    @Override
    protected SpringResourceThematicThymeleafResolverBuilder getSelf() {
        return this;
    }

    @Override
    protected SpringResourceThematicTemplateResolver doBuild() {
        SpringResourceThematicTemplateResolver resolver = new SpringResourceThematicTemplateResolver();
        resolver.setApplicationContext(this.applicationContext);
        resolver.setPrefix(this.thymeleafProperties.getPrefix());
        resolver.setSuffix(this.thymeleafProperties.getSuffix());
        resolver.setTemplateMode(this.thymeleafProperties.getMode());
        if (Objects.nonNull(this.thymeleafProperties.getEncoding())) {
            resolver.setCharacterEncoding(this.thymeleafProperties.getEncoding().name());
        }
        resolver.setCacheable(this.thymeleafProperties.isCache());
        Integer order = this.thymeleafProperties.getTemplateResolverOrder();
        if (Objects.nonNull(order)) {
            resolver.setOrder(order);
        }
        resolver.setCheckExistence(this.thymeleafProperties.isCheckTemplate());
        return resolver;
    }
}

