/*
 * Decompiled with CFR 0.152.
 */
package net.qimooc.thematic.thymeleaf.spring5.configuration;

import java.util.LinkedHashMap;
import net.qimooc.thematic.thymeleaf.configuration.ThematicResourcePathResolverBuilder;
import net.qimooc.thematic.thymeleaf.spring5.configuration.SpringResourceThematicThymeleafResolverBuilder;
import net.qimooc.thematic.thymeleaf.spring5.resolver.SpringResourceThematicTemplateResolver;
import net.qimooc.thematic.thymeleaf.spring5.view.ThematicThymeleafView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.thymeleaf.ThymeleafProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.MimeType;
import org.thymeleaf.spring5.ISpringTemplateEngine;
import org.thymeleaf.spring5.SpringTemplateEngine;
import org.thymeleaf.spring5.view.ThymeleafView;
import org.thymeleaf.spring5.view.ThymeleafViewResolver;

@Configuration
@EnableConfigurationProperties(value={ThymeleafProperties.class})
@ConditionalOnClass(value={ThymeleafView.class})
public class ThematicThymeleafConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ThematicThymeleafConfiguration.class);

    @Bean
    public SpringResourceThematicTemplateResolver springResourceThematicTemplateResolver(ThymeleafProperties properties, ApplicationContext applicationContext) {
        return (SpringResourceThematicTemplateResolver)((SpringResourceThematicThymeleafResolverBuilder)((SpringResourceThematicThymeleafResolverBuilder)new SpringResourceThematicThymeleafResolverBuilder().thematicResourcePathResolver(ThematicResourcePathResolverBuilder.thematicResourcePathResolver())).order(200)).thymeleafProperties(properties).applicationContext(applicationContext).build();
    }

    @Bean
    public SpringResourceThematicTemplateResolver defaultSpringResourceThematicResolver(ThymeleafProperties properties, ApplicationContext applicationContext) {
        return (SpringResourceThematicTemplateResolver)((SpringResourceThematicThymeleafResolverBuilder)((SpringResourceThematicThymeleafResolverBuilder)new SpringResourceThematicThymeleafResolverBuilder().thematicResourcePathResolver(ThematicResourcePathResolverBuilder.defaultThematicResourcePathResolver())).order(299)).thymeleafProperties(properties).applicationContext(applicationContext).build();
    }

    @Configuration(proxyBeanMethods=false)
    static class ThymeleafViewResolverConfiguration {
        ThymeleafViewResolverConfiguration() {
        }

        @Bean
        ThymeleafViewResolver thymeleafViewResolver(ThymeleafProperties properties, SpringTemplateEngine templateEngine) {
            ThymeleafViewResolver resolver = new ThymeleafViewResolver();
            resolver.setTemplateEngine((ISpringTemplateEngine)templateEngine);
            resolver.setCharacterEncoding(properties.getEncoding().name());
            resolver.setContentType(this.appendCharset(properties.getServlet().getContentType(), resolver.getCharacterEncoding()));
            resolver.setProducePartialOutputWhileProcessing(properties.getServlet().isProducePartialOutputWhileProcessing());
            resolver.setExcludedViewNames(properties.getExcludedViewNames());
            resolver.setViewNames(properties.getViewNames());
            resolver.setViewClass(ThematicThymeleafView.class);
            resolver.setOrder(0x7FFFFFFA);
            resolver.setCache(properties.isCache());
            return resolver;
        }

        private String appendCharset(MimeType type, String charset) {
            if (type.getCharset() != null) {
                return type.toString();
            }
            LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
            parameters.put("charset", charset);
            parameters.putAll(type.getParameters());
            return new MimeType(type, parameters).toString();
        }
    }
}

