/*
 *  Copyright 2004 Clinton Begin
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package com.ibatis.sqlmap.engine.mapping.parameter;


import com.ibatis.sqlmap.engine.impl.SqlMapExecutorDelegate;
import com.ibatis.sqlmap.engine.scope.RequestScope;

public class NoParameterMap extends BasicParameterMap {

  private static final ParameterMapping[] NO_PARAMETERS = new ParameterMapping[0];
  private static final Object[] NO_DATA = new Object[0];

  public NoParameterMap(SqlMapExecutorDelegate delegate) {
    super(delegate);
  }

  public ParameterMapping[] getParameterMappings() {
    return NO_PARAMETERS;
  }

  public Object[] getParameterObjectValues(RequestScope request, Object parameterObject) {
    return NO_DATA;
  }


}
