/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.tools;

import java.io.IOException;
import java.util.ArrayList;
import org.bytedeco.javacpp.tools.Info;
import org.bytedeco.javacpp.tools.InfoMap;
import org.bytedeco.javacpp.tools.Token;
import org.bytedeco.javacpp.tools.Tokenizer;

class TokenIndexer {
    boolean raw = false;
    InfoMap infoMap = null;
    Token[] array = null;
    int index = 0;

    TokenIndexer(InfoMap infoMap, Token[] array) {
        this.infoMap = infoMap;
        this.array = array;
    }

    void filter(int index) {
        if (index + 1 < this.array.length && this.array[index].match(Character.valueOf('#')) && this.array[index + 1].match(Token.IF, Token.IFDEF, Token.IFNDEF)) {
            ArrayList<Token> tokens = new ArrayList<Token>();
            for (int i = 0; i < index; ++i) {
                tokens.add(this.array[i]);
            }
            int count = 0;
            Info info = null;
            boolean define = true;
            boolean defined = false;
            while (index < this.array.length) {
                Token keyword = null;
                if (this.array[index].match(Character.valueOf('#'))) {
                    if (count == 0 && this.array[index + 1].match(Token.IF, Token.IFDEF, Token.IFNDEF)) {
                        ++count;
                        keyword = this.array[index + 1];
                    } else if (count == 1 && this.array[index + 1].match(Token.ELIF, Token.ELSE, Token.ENDIF)) {
                        keyword = this.array[index + 1];
                    }
                }
                if (keyword != null) {
                    tokens.add(this.array[index++]);
                    tokens.add(this.array[index++]);
                    if (keyword.match(Token.IF, Token.IFDEF, Token.IFNDEF, Token.ELIF)) {
                        String value = "";
                        while (index < this.array.length && this.array[index].spacing.indexOf(10) < 0) {
                            value = value + this.array[index].spacing + this.array[index];
                            tokens.add(this.array[index++]);
                        }
                        define = info == null || !defined;
                        info = this.infoMap.getFirst(value);
                        if (info != null) {
                            define = keyword.match(Token.IFNDEF) ? !info.define : info.define;
                        } else {
                            try {
                                define = Integer.parseInt(value.trim()) != 0;
                            }
                            catch (NumberFormatException e) {}
                        }
                    } else if (keyword.match(Token.ELSE)) {
                        define = info == null || !define;
                    } else if (keyword.match(Token.ENDIF) && --count == 0) {
                        break;
                    }
                } else if (define) {
                    tokens.add(this.array[index++]);
                } else {
                    ++index;
                }
                defined = define || defined;
            }
            while (index < this.array.length) {
                tokens.add(this.array[index++]);
            }
            this.array = tokens.toArray(new Token[tokens.size()]);
        }
    }

    void expand(int index) {
        if (index < this.array.length && this.infoMap.containsKey(this.array[index].value)) {
            int startIndex = index;
            Info info = this.infoMap.getFirst(this.array[index].value);
            if (info != null && info.cppText != null) {
                try {
                    Token token;
                    Tokenizer tokenizer = new Tokenizer(info.cppText);
                    if (!(tokenizer.nextToken().match(Character.valueOf('#')) && tokenizer.nextToken().match(Token.DEFINE) && tokenizer.nextToken().match(info.cppNames[0]) && tokenizer.nextToken().match(Character.valueOf('(')))) {
                        return;
                    }
                    ArrayList<String> params = new ArrayList<String>();
                    while (!(token = tokenizer.nextToken()).isEmpty()) {
                        if (token.match(5)) {
                            params.add(token.value);
                            continue;
                        }
                        if (!token.match(Character.valueOf(')'))) continue;
                    }
                    if (!(params.size() <= 0 || index + 1 < this.array.length && this.array[index + 1].match(Character.valueOf('(')))) {
                        return;
                    }
                    ArrayList<Token> tokens = new ArrayList<Token>();
                    for (int i = 0; i < index; ++i) {
                        tokens.add(this.array[i]);
                    }
                    ArrayList[] args = new ArrayList[params.size()];
                    int count = 0;
                    int count2 = 0;
                    index += 2;
                    while (index < this.array.length) {
                        token = this.array[index];
                        if (count2 == 0 && token.match(Character.valueOf(')'))) break;
                        if (count2 == 0 && token.match(Character.valueOf(','))) {
                            ++count;
                        } else {
                            if (token.match(Character.valueOf('('), Character.valueOf('['), Character.valueOf('{'))) {
                                ++count2;
                            } else if (token.match(Character.valueOf(')'), Character.valueOf(']'), Character.valueOf('}'))) {
                                --count2;
                            }
                            if (args[count] == null) {
                                args[count] = new ArrayList();
                            }
                            args[count].add(token);
                        }
                        ++index;
                    }
                    while (!(token = tokenizer.nextToken()).isEmpty()) {
                        boolean foundArg = false;
                        for (int i = 0; i < params.size(); ++i) {
                            if (!((String)params.get(i)).equals(token.value)) continue;
                            if (tokens.size() == startIndex) {
                                ((Token)args[i].get((int)0)).spacing = this.array[startIndex].spacing;
                            }
                            tokens.addAll(args[i]);
                            foundArg = true;
                            break;
                        }
                        if (foundArg) continue;
                        if (tokens.size() == startIndex) {
                            token.spacing = this.array[startIndex].spacing;
                        }
                        tokens.add(token);
                    }
                    ++index;
                    while (index < this.array.length) {
                        tokens.add(this.array[index]);
                        ++index;
                    }
                    this.array = tokens.toArray(new Token[tokens.size()]);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    int preprocess(int index, int count) {
        while (index < this.array.length) {
            this.filter(index);
            this.expand(index);
            if (!this.array[index].match(4) && --count < 0) break;
            ++index;
        }
        this.filter(index);
        this.expand(index);
        return index;
    }

    Token get() {
        return this.get(0);
    }

    Token get(int i) {
        int k = this.raw ? this.index + i : this.preprocess(this.index, i);
        return k < this.array.length ? this.array[k] : Token.EOF;
    }

    Token next() {
        this.index = this.raw ? this.index + 1 : this.preprocess(this.index, 1);
        return this.index < this.array.length ? this.array[this.index] : Token.EOF;
    }
}

