/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.core.variable;

import java.util.Map;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.core.CoreLogger;
import org.camunda.bpm.engine.impl.persistence.entity.util.TypedValueField;
import org.camunda.bpm.engine.impl.variable.serializer.TypedValueSerializer;
import org.camunda.bpm.engine.impl.variable.serializer.VariableSerializerFactory;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.SerializableValue;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class VariableUtil {
    public static CoreLogger CORE_LOGGER = ProcessEngineLogger.CORE_LOGGER;

    public static void checkJavaSerialization(String variableName, TypedValue value) {
        SerializableValue serializableValue;
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        if (value instanceof SerializableValue && !processEngineConfiguration.isJavaSerializationFormatEnabled() && !(serializableValue = (SerializableValue)value).isDeserialized()) {
            String javaSerializationDataFormat = Variables.SerializationDataFormats.JAVA.getName();
            String requestedDataFormat = serializableValue.getSerializationDataFormat();
            if (requestedDataFormat == null) {
                VariableSerializerFactory fallbackSerializerFactory = processEngineConfiguration.getFallbackSerializerFactory();
                TypedValueSerializer serializerForValue = TypedValueField.getSerializers().findSerializerForValue((TypedValue)serializableValue, fallbackSerializerFactory);
                if (serializerForValue != null) {
                    requestedDataFormat = serializerForValue.getSerializationDataformat();
                }
            }
            if (javaSerializationDataFormat.equals(requestedDataFormat)) {
                throw CORE_LOGGER.javaSerializationProhibitedException(variableName);
            }
        }
    }

    public static void setVariables(Map<String, ?> variables, SetVariableFunction setVariableFunction) {
        if (variables != null) {
            for (String variableName : variables.keySet()) {
                TypedValue value = null;
                value = variables instanceof VariableMap ? ((VariableMap)variables).getValueTyped(variableName) : (TypedValue)variables.get(variableName);
                setVariableFunction.apply(variableName, value);
            }
        }
    }

    @FunctionalInterface
    public static interface SetVariableFunction {
        public void apply(String var1, Object var2);
    }
}

