/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.engine.impl.cmd;

import org.flowable.app.api.repository.AppDefinition;
import org.flowable.app.engine.impl.cmd.NeedsAppDefinitionCmd;
import org.flowable.app.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class DeleteIdentityLinkCmd
extends NeedsAppDefinitionCmd<Void> {
    private static final long serialVersionUID = 1L;
    public static final int IDENTITY_USER = 1;
    public static final int IDENTITY_GROUP = 2;
    protected String userId;
    protected String groupId;
    protected String type;

    public DeleteIdentityLinkCmd(String appDefinitionId, String userId, String groupId, String type) {
        super(appDefinitionId);
        this.validateParams(userId, groupId, type, appDefinitionId);
        this.appDefinitionId = appDefinitionId;
        this.userId = userId;
        this.groupId = groupId;
        this.type = type;
    }

    protected void validateParams(String userId, String groupId, String type, String taskId) {
        if (this.appDefinitionId == null) {
            throw new FlowableIllegalArgumentException("appDefinitionId is null");
        }
        if (type == null) {
            throw new FlowableIllegalArgumentException("type is required when adding a new app identity link");
        }
        if (userId == null && groupId == null) {
            throw new FlowableIllegalArgumentException("userId and groupId cannot both be null");
        }
    }

    @Override
    protected Void execute(CommandContext commandContext, AppDefinition appDefinition) {
        CommandContextUtil.getIdentityLinkService().deleteScopeIdentityLink(this.appDefinitionId, "app", this.userId, this.groupId, this.type);
        return null;
    }
}

