/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.converter.export;

import java.util.List;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.constants.BpmnXMLConstants;
import org.flowable.bpmn.converter.util.BpmnXMLUtil;
import org.flowable.bpmn.model.MapExceptionEntry;

public class MapExceptionExport
implements BpmnXMLConstants {
    public static boolean writeMapExceptionExtensions(List<MapExceptionEntry> mapExceptionList, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        for (MapExceptionEntry mapException : mapExceptionList) {
            if (!didWriteExtensionStartElement) {
                xtw.writeStartElement("extensionElements");
                didWriteExtensionStartElement = true;
            }
            if (!StringUtils.isNotEmpty((CharSequence)mapException.getErrorCode())) continue;
            xtw.writeStartElement("flowable", "mapException", "http://flowable.org/bpmn");
            BpmnXMLUtil.writeDefaultAttribute("errorCode", mapException.getErrorCode(), xtw);
            BpmnXMLUtil.writeDefaultAttribute("includeChildExceptions", Boolean.toString(mapException.isAndChildren()), xtw);
            if (StringUtils.isNotEmpty((CharSequence)mapException.getClassName())) {
                xtw.writeCData(mapException.getClassName());
            }
            xtw.writeEndElement();
        }
        return didWriteExtensionStartElement;
    }
}

