/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.boot;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import org.flowable.common.engine.impl.history.HistoryLevel;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.DeprecatedConfigurationProperty;
import org.springframework.boot.convert.DurationUnit;

@ConfigurationProperties(prefix="flowable")
public class FlowableProperties {
    private boolean checkProcessDefinitions = true;
    private boolean asyncExecutorActivate = true;
    private boolean asyncHistoryExecutorActivate = true;
    private boolean restApiEnabled;
    private String activityFontName = "Arial";
    private String labelFontName = "Arial";
    private String annotationFontName = "Arial";
    private String deploymentName = "SpringBootAutoDeployment";
    private String databaseSchemaUpdate = "true";
    private String databaseSchema;
    private boolean useLockForDatabaseSchemaUpdate = false;
    @Deprecated
    private boolean isDbIdentityUsed = true;
    private boolean isDbHistoryUsed = true;
    private HistoryLevel historyLevel = HistoryLevel.AUDIT;
    private String processDefinitionLocationPrefix = "classpath*:/processes/";
    private List<String> processDefinitionLocationSuffixes = Arrays.asList("**.bpmn20.xml", "**.bpmn");
    private boolean jpaEnabled = true;
    private List<String> customMybatisMappers;
    private List<String> customMybatisXMLMappers;
    protected boolean formFieldValidationEnabled = false;
    private Duration lockPollRate = Duration.ofSeconds(10L);
    private Duration schemaLockWaitTime = Duration.ofMinutes(5L);
    private boolean enableHistoryCleaning = false;
    private String historyCleaningCycle = "0 0 1 * * ?";
    @DurationUnit(value=ChronoUnit.DAYS)
    private Duration historyCleaningAfter = Duration.ofDays(365L);
    private int historyCleaningBatchSize = 100;
    private boolean historyCleaningSequential = false;

    public boolean isAsyncExecutorActivate() {
        return this.asyncExecutorActivate;
    }

    public void setAsyncExecutorActivate(boolean asyncExecutorActivate) {
        this.asyncExecutorActivate = asyncExecutorActivate;
    }

    public boolean isAsyncHistoryExecutorActivate() {
        return this.asyncHistoryExecutorActivate;
    }

    public void setAsyncHistoryExecutorActivate(boolean asyncHistoryExecutorActivate) {
        this.asyncHistoryExecutorActivate = asyncHistoryExecutorActivate;
    }

    public boolean isRestApiEnabled() {
        return this.restApiEnabled;
    }

    public void setRestApiEnabled(boolean restApiEnabled) {
        this.restApiEnabled = restApiEnabled;
    }

    public boolean isJpaEnabled() {
        return this.jpaEnabled;
    }

    public void setJpaEnabled(boolean jpaEnabled) {
        this.jpaEnabled = jpaEnabled;
    }

    @DeprecatedConfigurationProperty(replacement="flowable.process.servlet.path")
    @Deprecated
    public String getRestApiMapping() {
        throw new IllegalStateException("Usage of deprecated property. Use FlowableProcessProperties");
    }

    @Deprecated
    public void setRestApiMapping(String restApiMapping) {
        throw new IllegalStateException("Usage of deprecated property. Use FlowableProcessProperties");
    }

    @DeprecatedConfigurationProperty(replacement="flowable.process.servlet.name")
    @Deprecated
    public String getRestApiServletName() {
        throw new IllegalStateException("Usage of deprecated property. Use FlowableProcessProperties");
    }

    @Deprecated
    public void setRestApiServletName(String restApiServletName) {
        throw new IllegalStateException("Usage of deprecated property. Use FlowableProcessProperties");
    }

    public boolean isCheckProcessDefinitions() {
        return this.checkProcessDefinitions;
    }

    public void setCheckProcessDefinitions(boolean checkProcessDefinitions) {
        this.checkProcessDefinitions = checkProcessDefinitions;
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public void setDeploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
    }

    public String getDatabaseSchemaUpdate() {
        return this.databaseSchemaUpdate;
    }

    public void setDatabaseSchemaUpdate(String databaseSchemaUpdate) {
        this.databaseSchemaUpdate = databaseSchemaUpdate;
    }

    public String getDatabaseSchema() {
        return this.databaseSchema;
    }

    public void setDatabaseSchema(String databaseSchema) {
        this.databaseSchema = databaseSchema;
    }

    public boolean isUseLockForDatabaseSchemaUpdate() {
        return this.useLockForDatabaseSchemaUpdate;
    }

    public void setUseLockForDatabaseSchemaUpdate(boolean useLockForDatabaseSchemaUpdate) {
        this.useLockForDatabaseSchemaUpdate = useLockForDatabaseSchemaUpdate;
    }

    @DeprecatedConfigurationProperty(replacement="flowable.idm.enabled")
    @Deprecated
    public boolean isDbIdentityUsed() {
        return this.isDbIdentityUsed;
    }

    @Deprecated
    public void setDbIdentityUsed(boolean isDbIdentityUsed) {
        this.isDbIdentityUsed = isDbIdentityUsed;
    }

    public boolean isDbHistoryUsed() {
        return this.isDbHistoryUsed;
    }

    public void setDbHistoryUsed(boolean isDbHistoryUsed) {
        this.isDbHistoryUsed = isDbHistoryUsed;
    }

    public HistoryLevel getHistoryLevel() {
        return this.historyLevel;
    }

    public void setHistoryLevel(HistoryLevel historyLevel) {
        this.historyLevel = historyLevel;
    }

    public String getProcessDefinitionLocationPrefix() {
        return this.processDefinitionLocationPrefix;
    }

    public void setProcessDefinitionLocationPrefix(String processDefinitionLocationPrefix) {
        this.processDefinitionLocationPrefix = processDefinitionLocationPrefix;
    }

    public List<String> getProcessDefinitionLocationSuffixes() {
        return this.processDefinitionLocationSuffixes;
    }

    public void setProcessDefinitionLocationSuffixes(List<String> processDefinitionLocationSuffixes) {
        this.processDefinitionLocationSuffixes = processDefinitionLocationSuffixes;
    }

    public List<String> getCustomMybatisMappers() {
        return this.customMybatisMappers;
    }

    public void setCustomMybatisMappers(List<String> customMyBatisMappers) {
        this.customMybatisMappers = customMyBatisMappers;
    }

    public List<String> getCustomMybatisXMLMappers() {
        return this.customMybatisXMLMappers;
    }

    public void setCustomMybatisXMLMappers(List<String> customMybatisXMLMappers) {
        this.customMybatisXMLMappers = customMybatisXMLMappers;
    }

    public String getActivityFontName() {
        return this.activityFontName;
    }

    public void setActivityFontName(String activityFontName) {
        this.activityFontName = activityFontName;
    }

    public String getLabelFontName() {
        return this.labelFontName;
    }

    public void setLabelFontName(String labelFontName) {
        this.labelFontName = labelFontName;
    }

    public String getAnnotationFontName() {
        return this.annotationFontName;
    }

    public void setAnnotationFontName(String annotationFontName) {
        this.annotationFontName = annotationFontName;
    }

    public boolean isFormFieldValidationEnabled() {
        return this.formFieldValidationEnabled;
    }

    public void setFormFieldValidationEnabled(boolean formFieldValidationEnabled) {
        this.formFieldValidationEnabled = formFieldValidationEnabled;
    }

    public Duration getLockPollRate() {
        return this.lockPollRate;
    }

    public void setLockPollRate(Duration lockPollRate) {
        this.lockPollRate = lockPollRate;
    }

    public Duration getSchemaLockWaitTime() {
        return this.schemaLockWaitTime;
    }

    public void setSchemaLockWaitTime(Duration schemaLockWaitTime) {
        this.schemaLockWaitTime = schemaLockWaitTime;
    }

    public boolean isEnableHistoryCleaning() {
        return this.enableHistoryCleaning;
    }

    public void setEnableHistoryCleaning(boolean enableHistoryCleaning) {
        this.enableHistoryCleaning = enableHistoryCleaning;
    }

    public String getHistoryCleaningCycle() {
        return this.historyCleaningCycle;
    }

    public void setHistoryCleaningCycle(String historyCleaningCycle) {
        this.historyCleaningCycle = historyCleaningCycle;
    }

    @Deprecated
    @DeprecatedConfigurationProperty(replacement="flowable.history-cleaning-after", reason="Switched to using a Duration that allows more flexible configuration")
    public void setHistoryCleaningAfterDays(int historyCleaningAfterDays) {
        this.historyCleaningAfter = Duration.ofDays(historyCleaningAfterDays);
    }

    public Duration getHistoryCleaningAfter() {
        return this.historyCleaningAfter;
    }

    public void setHistoryCleaningAfter(Duration historyCleaningAfter) {
        this.historyCleaningAfter = historyCleaningAfter;
    }

    public int getHistoryCleaningBatchSize() {
        return this.historyCleaningBatchSize;
    }

    public void setHistoryCleaningBatchSize(int historyCleaningBatchSize) {
        this.historyCleaningBatchSize = historyCleaningBatchSize;
    }

    public boolean isHistoryCleaningSequential() {
        return this.historyCleaningSequential;
    }

    public void setHistoryCleaningSequential(boolean historyCleaningSequential) {
        this.historyCleaningSequential = historyCleaningSequential;
    }
}

