/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import com.sun.jersey.api.client.ClientResponse;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.rest.AbstractRestFunctionalDocTestBase;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.test.GraphDescription;
import org.neo4j.test.TestData;
import org.neo4j.test.mockito.matcher.Neo4jMatchers;

public class RelationshipIT
extends AbstractRestFunctionalDocTestBase {
    private static FunctionalTestHelper functionalTestHelper;

    @BeforeClass
    public static void setupServer() {
        functionalTestHelper = new FunctionalTestHelper(RelationshipIT.server());
    }

    @Test
    @TestData.Title(value="Remove properties from a relationship")
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="Romeo", setNameProperty=true), @GraphDescription.NODE(name="Juliet", setNameProperty=true)}, relationships={@GraphDescription.REL(start="Romeo", end="Juliet", type="LOVES", properties={@GraphDescription.PROP(key="cost", value="high", type=GraphDescription.PropType.STRING)})})
    public void shouldReturn204WhenPropertiesAreRemovedFromRelationship() {
        Relationship loves = this.getFirstRelationshipFromRomeoNode();
        this.gen().expectedStatus(Response.Status.NO_CONTENT.getStatusCode()).delete(functionalTestHelper.relationshipPropertiesUri(loves.getId())).entity();
    }

    @Test
    @GraphDescription.Graph(value={"I know you"})
    public void get_Relationship_by_ID() throws JsonParseException {
        Relationship relationship;
        Node node = (Node)((Map)this.data.get()).get("I");
        try (Transaction transaction = node.getGraphDatabase().beginTx();){
            relationship = node.getSingleRelationship(RelationshipType.withName((String)"know"), Direction.OUTGOING);
        }
        String response = this.gen().expectedStatus(ClientResponse.Status.OK.getStatusCode()).get(this.getRelationshipUri(relationship)).entity();
        Assert.assertTrue((boolean)JsonHelper.jsonToMap((String)response).containsKey("start"));
    }

    @Test
    @TestData.Title(value="Remove property from a relationship")
    @Documented(value="See the example request below.")
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="Romeo", setNameProperty=true), @GraphDescription.NODE(name="Juliet", setNameProperty=true)}, relationships={@GraphDescription.REL(start="Romeo", end="Juliet", type="LOVES", properties={@GraphDescription.PROP(key="cost", value="high", type=GraphDescription.PropType.STRING)})})
    public void shouldReturn204WhenPropertyIsRemovedFromRelationship() {
        this.data.get();
        Relationship loves = this.getFirstRelationshipFromRomeoNode();
        this.gen().expectedStatus(Response.Status.NO_CONTENT.getStatusCode()).delete(this.getPropertiesUri(loves) + "/cost").entity();
    }

    @Test
    @TestData.Title(value="Remove non-existent property from a relationship")
    @Documented(value="Attempting to remove a property that doesn't exist results in an error.")
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="Romeo", setNameProperty=true), @GraphDescription.NODE(name="Juliet", setNameProperty=true)}, relationships={@GraphDescription.REL(start="Romeo", end="Juliet", type="LOVES", properties={@GraphDescription.PROP(key="cost", value="high", type=GraphDescription.PropType.STRING)})})
    public void shouldReturn404WhenPropertyWhichDoesNotExistRemovedFromRelationship() {
        this.data.get();
        Relationship loves = this.getFirstRelationshipFromRomeoNode();
        this.gen().expectedStatus(Response.Status.NOT_FOUND.getStatusCode()).delete(this.getPropertiesUri(loves) + "/non-existent").entity();
    }

    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="Romeo", setNameProperty=true), @GraphDescription.NODE(name="Juliet", setNameProperty=true)}, relationships={@GraphDescription.REL(start="Romeo", end="Juliet", type="LOVES", properties={@GraphDescription.PROP(key="cost", value="high", type=GraphDescription.PropType.STRING)})})
    public void shouldReturn404WhenPropertyWhichDoesNotExistRemovedFromRelationshipStreaming() {
        this.data.get();
        Relationship loves = this.getFirstRelationshipFromRomeoNode();
        this.gen().withHeader("X-Stream", "true").expectedStatus(Response.Status.NOT_FOUND.getStatusCode()).delete(this.getPropertiesUri(loves) + "/non-existent").entity();
    }

    @Test
    @GraphDescription.Graph(value={"I know you"})
    @TestData.Title(value="Remove properties from a non-existing relationship")
    @Documented(value="Attempting to remove all properties from a relationship which doesn't exist results in an error.")
    public void shouldReturn404WhenPropertiesRemovedFromARelationshipWhichDoesNotExist() {
        this.data.get();
        this.gen().expectedStatus(Response.Status.NOT_FOUND.getStatusCode()).delete(functionalTestHelper.relationshipPropertiesUri(1234L)).entity();
    }

    @Test
    @GraphDescription.Graph(value={"I know you"})
    @TestData.Title(value="Remove property from a non-existing relationship")
    @Documented(value="Attempting to remove a property from a relationship which doesn't exist results in an error.")
    public void shouldReturn404WhenPropertyRemovedFromARelationshipWhichDoesNotExist() {
        this.data.get();
        this.gen().expectedStatus(Response.Status.NOT_FOUND.getStatusCode()).delete(functionalTestHelper.relationshipPropertiesUri(1234L) + "/cost").entity();
    }

    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="Romeo", setNameProperty=true), @GraphDescription.NODE(name="Juliet", setNameProperty=true)}, relationships={@GraphDescription.REL(start="Romeo", end="Juliet", type="LOVES", properties={@GraphDescription.PROP(key="cost", value="high", type=GraphDescription.PropType.STRING)})})
    @TestData.Title(value="Delete relationship")
    public void removeRelationship() {
        this.data.get();
        Relationship loves = this.getFirstRelationshipFromRomeoNode();
        this.gen().expectedStatus(Response.Status.NO_CONTENT.getStatusCode()).delete(this.getRelationshipUri(loves)).entity();
    }

    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="Romeo", setNameProperty=true), @GraphDescription.NODE(name="Juliet", setNameProperty=true)}, relationships={@GraphDescription.REL(start="Romeo", end="Juliet", type="LOVES", properties={@GraphDescription.PROP(key="cost", value="high", type=GraphDescription.PropType.STRING)})})
    public void get_single_property_on_a_relationship() {
        Relationship loves = this.getFirstRelationshipFromRomeoNode();
        String response = this.gen().expectedStatus(ClientResponse.Status.OK).get(this.getRelPropURI(loves, "cost")).entity();
        Assert.assertTrue((boolean)response.contains("high"));
    }

    private String getRelPropURI(Relationship loves, String propertyKey) {
        return this.getRelationshipUri(loves) + "/properties/" + propertyKey;
    }

    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="Romeo", setNameProperty=true), @GraphDescription.NODE(name="Juliet", setNameProperty=true)}, relationships={@GraphDescription.REL(start="Romeo", end="Juliet", type="LOVES", properties={@GraphDescription.PROP(key="cost", value="high", type=GraphDescription.PropType.STRING)})})
    public void set_single_property_on_a_relationship() {
        Relationship loves = this.getFirstRelationshipFromRomeoNode();
        Assert.assertThat((Object)loves, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)this.graphdb(), (Matcher)Neo4jMatchers.hasProperty((String)"cost").withValue((Object)"high")));
        this.gen().expectedStatus(ClientResponse.Status.NO_CONTENT).payload("\"deadly\"").put(this.getRelPropURI(loves, "cost")).entity();
        Assert.assertThat((Object)loves, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)this.graphdb(), (Matcher)Neo4jMatchers.hasProperty((String)"cost").withValue((Object)"deadly")));
    }

    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="Romeo", setNameProperty=true), @GraphDescription.NODE(name="Juliet", setNameProperty=true)}, relationships={@GraphDescription.REL(start="Romeo", end="Juliet", type="LOVES", properties={@GraphDescription.PROP(key="cost", value="high", type=GraphDescription.PropType.STRING), @GraphDescription.PROP(key="since", value="1day", type=GraphDescription.PropType.STRING)})})
    public void set_all_properties_on_a_relationship() {
        Relationship loves = this.getFirstRelationshipFromRomeoNode();
        Assert.assertThat((Object)loves, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)this.graphdb(), (Matcher)Neo4jMatchers.hasProperty((String)"cost").withValue((Object)"high")));
        this.gen().expectedStatus(ClientResponse.Status.NO_CONTENT).payload(JsonHelper.createJsonFrom((Object)MapUtil.map((Object[])new Object[]{"happy", false}))).put(this.getRelPropsURI(loves)).entity();
        Assert.assertThat((Object)loves, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)this.graphdb(), (Matcher)Neo4jMatchers.hasProperty((String)"happy").withValue((Object)false)));
        Assert.assertThat((Object)loves, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)this.graphdb(), (Matcher)IsNot.not((Matcher)Neo4jMatchers.hasProperty((String)"cost"))));
    }

    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="Romeo", setNameProperty=true), @GraphDescription.NODE(name="Juliet", setNameProperty=true)}, relationships={@GraphDescription.REL(start="Romeo", end="Juliet", type="LOVES", properties={@GraphDescription.PROP(key="cost", value="high", type=GraphDescription.PropType.STRING), @GraphDescription.PROP(key="since", value="1day", type=GraphDescription.PropType.STRING)})})
    public void get_all_properties_on_a_relationship() {
        Relationship loves = this.getFirstRelationshipFromRomeoNode();
        String response = this.gen().expectedStatus(ClientResponse.Status.OK).get(this.getRelPropsURI(loves)).entity();
        Assert.assertTrue((boolean)response.contains("high"));
    }

    /*
     * Exception decompiling
     */
    private Relationship getFirstRelationshipFromRomeoNode() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getRelPropsURI(Relationship rel) {
        return this.getRelationshipUri(rel) + "/properties";
    }
}

