/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.scripting;

import java.util.HashMap;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.server.scripting.NoSuchScriptLanguageException;
import org.neo4j.server.scripting.ScriptExecutor;
import org.neo4j.server.scripting.ScriptExecutorFactoryRepository;

public class TestScriptExecutorFactoryRepository {
    @Test(expected=NoSuchScriptLanguageException.class)
    public void shouldThrowNoSuchScriptLanguageExceptionForUnkownLanguages() {
        ScriptExecutorFactoryRepository repo = new ScriptExecutorFactoryRepository(new HashMap());
        repo.getFactory("Blah");
    }

    @Test
    public void shouldReturnRegisteredFactory() {
        HashMap<String, Object> languages = new HashMap<String, Object>();
        languages.put("js", Mockito.mock(ScriptExecutor.Factory.class));
        ScriptExecutorFactoryRepository repo = new ScriptExecutorFactoryRepository(languages);
        ScriptExecutor.Factory factory = repo.getFactory("js");
        Assert.assertThat((Object)factory, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
    }
}

