/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import java.io.File;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.neo4j.backup.impl.BackupClient;
import org.neo4j.backup.impl.BackupOutcome;
import org.neo4j.backup.impl.BackupProtocolService;
import org.neo4j.backup.impl.ConsistencyCheck;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class OnlineBackup {
    private final String hostNameOrIp;
    private final int port;
    private boolean forensics;
    private BackupOutcome outcome;
    private long timeoutMillis = BackupClient.BIG_READ_TIMEOUT;
    private OutputStream out = System.out;

    public static OnlineBackup from(String hostNameOrIp, int port) {
        return new OnlineBackup(hostNameOrIp, port);
    }

    public static OnlineBackup from(String hostNameOrIp) {
        return new OnlineBackup(hostNameOrIp, 6362);
    }

    private OnlineBackup(String hostNameOrIp, int port) {
        this.hostNameOrIp = hostNameOrIp;
        this.port = port;
    }

    @Deprecated
    public OnlineBackup backup(String targetDirectory) {
        return this.backup(new File(targetDirectory));
    }

    public OnlineBackup backup(File targetDirectory) {
        Path dir = targetDirectory.toPath();
        this.outcome = new BackupProtocolService(this.out).doIncrementalBackupOrFallbackToFull(this.hostNameOrIp, this.port, dir, OnlineBackup.getConsistencyCheck(true), this.defaultConfig(), this.timeoutMillis, this.forensics);
        return this;
    }

    @Deprecated
    public OnlineBackup backup(String targetDirectory, boolean verification) {
        return this.backup(new File(targetDirectory), verification);
    }

    public OnlineBackup backup(File targetDirectory, boolean verification) {
        this.outcome = new BackupProtocolService(this.out).doIncrementalBackupOrFallbackToFull(this.hostNameOrIp, this.port, targetDirectory.toPath(), OnlineBackup.getConsistencyCheck(verification), this.defaultConfig(), this.timeoutMillis, this.forensics);
        return this;
    }

    @Deprecated
    public OnlineBackup backup(String targetDirectory, Config tuningConfiguration) {
        return this.backup(new File(targetDirectory), tuningConfiguration);
    }

    public OnlineBackup backup(File targetDirectory, Config tuningConfiguration) {
        this.outcome = new BackupProtocolService(this.out).doIncrementalBackupOrFallbackToFull(this.hostNameOrIp, this.port, targetDirectory.toPath(), OnlineBackup.getConsistencyCheck(true), tuningConfiguration, this.timeoutMillis, this.forensics);
        return this;
    }

    @Deprecated
    public OnlineBackup backup(String targetDirectory, Config tuningConfiguration, boolean verification) {
        return this.backup(new File(targetDirectory), tuningConfiguration, verification);
    }

    public OnlineBackup backup(File targetDirectory, Config tuningConfiguration, boolean verification) {
        this.outcome = new BackupProtocolService(this.out).doIncrementalBackupOrFallbackToFull(this.hostNameOrIp, this.port, targetDirectory.toPath(), OnlineBackup.getConsistencyCheck(verification), tuningConfiguration, this.timeoutMillis, this.forensics);
        return this;
    }

    public OnlineBackup withTimeout(long timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
        return this;
    }

    public OnlineBackup withOutput(OutputStream out) {
        this.out = out;
        return this;
    }

    @Deprecated
    public OnlineBackup full(String targetDirectory) {
        this.outcome = new BackupProtocolService(this.out).doFullBackup(this.hostNameOrIp, this.port, Paths.get(targetDirectory, new String[0]), OnlineBackup.getConsistencyCheck(true), this.defaultConfig(), this.timeoutMillis, this.forensics);
        return this;
    }

    @Deprecated
    public OnlineBackup full(String targetDirectory, boolean verification) {
        this.outcome = new BackupProtocolService(this.out).doFullBackup(this.hostNameOrIp, this.port, Paths.get(targetDirectory, new String[0]), OnlineBackup.getConsistencyCheck(verification), this.defaultConfig(), this.timeoutMillis, this.forensics);
        return this;
    }

    @Deprecated
    public OnlineBackup full(String targetDirectory, boolean verification, Config tuningConfiguration) {
        this.outcome = new BackupProtocolService(this.out).doFullBackup(this.hostNameOrIp, this.port, Paths.get(targetDirectory, new String[0]), OnlineBackup.getConsistencyCheck(verification), tuningConfiguration, this.timeoutMillis, this.forensics);
        return this;
    }

    @Deprecated
    public OnlineBackup incremental(String targetDirectory) {
        this.outcome = new BackupProtocolService(this.out).doIncrementalBackup(this.hostNameOrIp, this.port, Paths.get(targetDirectory, new String[0]), OnlineBackup.getConsistencyCheck(false), this.timeoutMillis, this.defaultConfig());
        return this;
    }

    @Deprecated
    public OnlineBackup incremental(String targetDirectory, boolean verification) {
        this.outcome = new BackupProtocolService(this.out).doIncrementalBackup(this.hostNameOrIp, this.port, Paths.get(targetDirectory, new String[0]), OnlineBackup.getConsistencyCheck(verification), this.timeoutMillis, this.defaultConfig());
        return this;
    }

    @Deprecated
    public OnlineBackup incremental(GraphDatabaseAPI targetDb) {
        this.outcome = new BackupProtocolService(this.out).doIncrementalBackup(this.hostNameOrIp, this.port, targetDb, this.timeoutMillis);
        return this;
    }

    public long getLastCommittedTx() {
        return this.outcome().getLastCommittedTx();
    }

    public boolean isConsistent() {
        return this.outcome().isConsistent();
    }

    private BackupOutcome outcome() {
        if (this.outcome == null) {
            throw new IllegalStateException("No outcome yet. Please call full or incremental backup first");
        }
        return this.outcome;
    }

    private Config defaultConfig() {
        return Config.defaults();
    }

    public OnlineBackup gatheringForensics(boolean forensics) {
        this.forensics = forensics;
        return this;
    }

    private static ConsistencyCheck getConsistencyCheck(boolean verification) {
        return verification ? ConsistencyCheck.FULL : ConsistencyCheck.NONE;
    }
}

