/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.impl;

import java.io.IOException;
import java.nio.file.Path;
import org.neo4j.causalclustering.catchup.CatchUpClient;
import org.neo4j.causalclustering.catchup.CatchupAddressProvider;
import org.neo4j.causalclustering.catchup.CatchupResult;
import org.neo4j.causalclustering.catchup.storecopy.RemoteStore;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyClient;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFailedException;
import org.neo4j.causalclustering.catchup.storecopy.StoreIdDownloadFailedException;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

class BackupDelegator
extends LifecycleAdapter {
    private final RemoteStore remoteStore;
    private final CatchUpClient catchUpClient;
    private final StoreCopyClient storeCopyClient;

    BackupDelegator(RemoteStore remoteStore, CatchUpClient catchUpClient, StoreCopyClient storeCopyClient) {
        this.remoteStore = remoteStore;
        this.catchUpClient = catchUpClient;
        this.storeCopyClient = storeCopyClient;
    }

    void copy(AdvertisedSocketAddress fromAddress, StoreId expectedStoreId, Path destDir) throws StoreCopyFailedException {
        this.remoteStore.copy((CatchupAddressProvider)new CatchupAddressProvider.SingleAddressProvider(fromAddress), expectedStoreId, destDir.toFile());
    }

    CatchupResult tryCatchingUp(AdvertisedSocketAddress fromAddress, StoreId expectedStoreId, Path storeDir) throws StoreCopyFailedException {
        try {
            return this.remoteStore.tryCatchingUp(fromAddress, expectedStoreId, storeDir.toFile(), true);
        }
        catch (IOException e) {
            throw new StoreCopyFailedException((Throwable)e);
        }
    }

    public void start() {
        this.catchUpClient.start();
    }

    public void stop() {
        this.catchUpClient.stop();
    }

    public StoreId fetchStoreId(AdvertisedSocketAddress fromAddress) throws StoreIdDownloadFailedException {
        return this.storeCopyClient.fetchStoreId(fromAddress);
    }
}

