/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.impl;

import java.io.OutputStream;
import org.neo4j.com.storecopy.StoreCopyClientMonitor;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.Log;

class BackupOutputMonitor
implements StoreCopyClientMonitor {
    private final Log log;

    BackupOutputMonitor(OutsideWorld outsideWorld) {
        FormattedLogProvider stdOutLogProvider = FormattedLogProvider.toOutputStream((OutputStream)outsideWorld.outStream());
        this.log = stdOutLogProvider.getLog(BackupOutputMonitor.class);
    }

    public void startReceivingStoreFiles() {
        this.log.info("Start receiving store files");
    }

    public void finishReceivingStoreFiles() {
        this.log.info("Finish receiving store files");
    }

    public void startReceivingStoreFile(String file) {
        this.log.info("Start receiving store file %s", new Object[]{file});
    }

    public void finishReceivingStoreFile(String file) {
        this.log.info("Finish receiving store file %s", new Object[]{file});
    }

    public void startReceivingTransactions(long startTxId) {
        this.log.info("Start receiving transactions from %d", new Object[]{startTxId});
    }

    public void finishReceivingTransactions(long endTxId) {
        this.log.info("Finish receiving transactions at %d", new Object[]{endTxId});
    }

    public void startRecoveringStore() {
        this.log.info("Start recovering store");
    }

    public void finishRecoveringStore() {
        this.log.info("Finish recovering store");
    }

    public void startReceivingIndexSnapshots() {
        this.log.info("Start receiving index snapshots");
    }

    public void startReceivingIndexSnapshot(long indexId) {
        this.log.info("Start receiving index snapshot id %d", new Object[]{indexId});
    }

    public void finishReceivingIndexSnapshot(long indexId) {
        this.log.info("Finished receiving index snapshot id %d", new Object[]{indexId});
    }

    public void finishReceivingIndexSnapshots() {
        this.log.info("Finished receiving index snapshots");
    }
}

