/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.impl;

import java.nio.file.Path;
import java.util.Map;
import org.neo4j.backup.impl.BackupProtocolService;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

class BackupRecoveryService {
    BackupRecoveryService() {
    }

    public void recoverWithDatabase(Path targetDirectory, PageCache pageCache, Config config) {
        Map configParams = config.getRaw();
        configParams.put(GraphDatabaseSettings.logical_logs_location.name(), targetDirectory.toString());
        configParams.put(GraphDatabaseSettings.pagecache_warmup_enabled.name(), "false");
        GraphDatabaseAPI targetDb = BackupProtocolService.startTemporaryDb(targetDirectory, pageCache, configParams);
        targetDb.shutdown();
    }
}

