/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.impl;

import java.io.IOException;
import java.nio.file.Path;
import org.neo4j.backup.impl.BackupCopyService;
import org.neo4j.backup.impl.BackupRecoveryService;
import org.neo4j.backup.impl.BackupStageOutcome;
import org.neo4j.backup.impl.BackupStrategy;
import org.neo4j.backup.impl.BackupStrategyOutcome;
import org.neo4j.backup.impl.Fallible;
import org.neo4j.backup.impl.OnlineBackupContext;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.util.OptionalHostnamePort;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

class BackupStrategyWrapper {
    private final BackupStrategy backupStrategy;
    private final BackupCopyService backupCopyService;
    private final BackupRecoveryService backupRecoveryService;
    private final Log log;
    private final PageCache pageCache;
    private final Config config;

    BackupStrategyWrapper(BackupStrategy backupStrategy, BackupCopyService backupCopyService, PageCache pageCache, Config config, BackupRecoveryService backupRecoveryService, LogProvider logProvider) {
        this.backupStrategy = backupStrategy;
        this.backupCopyService = backupCopyService;
        this.pageCache = pageCache;
        this.config = config;
        this.backupRecoveryService = backupRecoveryService;
        this.log = logProvider.getLog(BackupStrategyWrapper.class);
    }

    Fallible<BackupStrategyOutcome> doBackup(OnlineBackupContext onlineBackupContext) {
        LifeSupport lifeSupport = new LifeSupport();
        lifeSupport.add((Lifecycle)this.backupStrategy);
        lifeSupport.start();
        Fallible<BackupStrategyOutcome> state = this.performBackupWithoutLifecycle(onlineBackupContext);
        lifeSupport.shutdown();
        return state;
    }

    private Fallible<BackupStrategyOutcome> performBackupWithoutLifecycle(OnlineBackupContext onlineBackupContext) {
        Path backupLocation = onlineBackupContext.getResolvedLocationFromName();
        Path userSpecifiedBackupLocation = onlineBackupContext.getResolvedLocationFromName();
        OptionalHostnamePort userSpecifiedAddress = onlineBackupContext.getRequiredArguments().getAddress();
        this.log.debug("User specified address is %s:%s", new Object[]{userSpecifiedAddress.getHostname().toString(), userSpecifiedAddress.getPort().toString()});
        Config config = onlineBackupContext.getConfig();
        boolean previousBackupExists = this.backupCopyService.backupExists(backupLocation);
        if (previousBackupExists) {
            this.log.info("Previous backup found, trying incremental backup.");
            Fallible<BackupStageOutcome> state = this.backupStrategy.performIncrementalBackup(userSpecifiedBackupLocation, config, userSpecifiedAddress);
            boolean fullBackupWontWork = BackupStageOutcome.WRONG_PROTOCOL.equals((Object)state.getState());
            boolean incrementalWasSuccessful = BackupStageOutcome.SUCCESS.equals((Object)state.getState());
            if (fullBackupWontWork || incrementalWasSuccessful) {
                this.clearIdFiles(backupLocation);
                return this.describeOutcome(state);
            }
            if (!onlineBackupContext.getRequiredArguments().isFallbackToFull()) {
                return this.describeOutcome(state);
            }
        }
        if (onlineBackupContext.getRequiredArguments().isFallbackToFull()) {
            if (!previousBackupExists) {
                this.log.info("Previous backup not found, a new full backup will be performed.");
            }
            return this.describeOutcome(this.fullBackupWithTemporaryFolderResolutions(onlineBackupContext));
        }
        return new Fallible<BackupStrategyOutcome>(BackupStrategyOutcome.INCORRECT_STRATEGY, null);
    }

    private void clearIdFiles(Path backupLocation) {
        try {
            this.backupCopyService.clearIdFiles(backupLocation);
        }
        catch (IOException e) {
            this.log.warn("Failed to delete some or all id files.", (Throwable)e);
        }
    }

    private Fallible<BackupStageOutcome> fullBackupWithTemporaryFolderResolutions(OnlineBackupContext onlineBackupContext) {
        Path userSpecifiedBackupLocation = onlineBackupContext.getResolvedLocationFromName();
        Path temporaryFullBackupLocation = this.backupCopyService.findAnAvailableLocationForNewFullBackup(userSpecifiedBackupLocation);
        OptionalHostnamePort address = onlineBackupContext.getRequiredArguments().getAddress();
        Fallible<BackupStageOutcome> state = this.backupStrategy.performFullBackup(temporaryFullBackupLocation, this.config, address);
        boolean aBackupAlreadyExisted = userSpecifiedBackupLocation.equals(temporaryFullBackupLocation);
        if (BackupStageOutcome.SUCCESS.equals((Object)state.getState())) {
            this.backupRecoveryService.recoverWithDatabase(temporaryFullBackupLocation, this.pageCache, this.config);
            if (!aBackupAlreadyExisted) {
                try {
                    this.renameTemporaryBackupToExpected(temporaryFullBackupLocation, userSpecifiedBackupLocation);
                }
                catch (IOException e) {
                    return new Fallible<BackupStageOutcome>(BackupStageOutcome.UNRECOVERABLE_FAILURE, e);
                }
            }
            this.clearIdFiles(userSpecifiedBackupLocation);
        }
        return state;
    }

    private void renameTemporaryBackupToExpected(Path temporaryFullBackupLocation, Path userSpecifiedBackupLocation) throws IOException {
        Path newBackupLocationForPreExistingBackup = this.backupCopyService.findNewBackupLocationForBrokenExisting(userSpecifiedBackupLocation);
        this.backupCopyService.moveBackupLocation(userSpecifiedBackupLocation, newBackupLocationForPreExistingBackup);
        this.backupCopyService.moveBackupLocation(temporaryFullBackupLocation, userSpecifiedBackupLocation);
    }

    private Fallible<BackupStrategyOutcome> describeOutcome(Fallible<BackupStageOutcome> strategyStageOutcome) {
        BackupStageOutcome stageOutcome = strategyStageOutcome.getState();
        if (stageOutcome == BackupStageOutcome.SUCCESS) {
            return new Fallible<BackupStrategyOutcome>(BackupStrategyOutcome.SUCCESS, null);
        }
        if (stageOutcome == BackupStageOutcome.WRONG_PROTOCOL) {
            return new Fallible<BackupStrategyOutcome>(BackupStrategyOutcome.INCORRECT_STRATEGY, strategyStageOutcome.getCause().orElse(null));
        }
        if (stageOutcome == BackupStageOutcome.FAILURE) {
            return new Fallible<BackupStrategyOutcome>(BackupStrategyOutcome.CORRECT_STRATEGY_FAILED, strategyStageOutcome.getCause().orElse(null));
        }
        if (stageOutcome == BackupStageOutcome.UNRECOVERABLE_FAILURE) {
            return new Fallible<BackupStrategyOutcome>(BackupStrategyOutcome.ABSOLUTE_FAILURE, strategyStageOutcome.getCause().orElse(null));
        }
        throw new RuntimeException("Not all enums covered: " + (Object)((Object)stageOutcome));
    }
}

